<?php

namespace App\Http\Controllers;

use App\Models\Department;

use App\Http\Requests\StoreDepartmentRequest;
use App\Http\Requests\UpdateDepartmentRequest;

class DepartmentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $departments = Department::all();
        return view('admin.departments.index')
            ->with('title', 'Departments')
            ->with('departments', $departments);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.departments.form')
        ->with('action', 'create')
        ->with('title', 'Create Department');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreDepartmentRequest $request)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        Department::create($request->all());
        return redirect(route('departments.index'))->with('success','Department created successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(Department $department)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.departments.show', ['department'=>$department])
            ->with('title', 'View ' . $department->name);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Department $department)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.departments.form')
            ->with('action', 'edit')
            ->with('title', 'Edit ' . $department->name)
            ->with('department', $department);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateDepartmentRequest $request, Department $department)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $department->update($request->all());
        return redirect(route('departments.index'))->with('success','Department ' . $department->name . ' updated successfully!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\School  $department
     * @return \Illuminate\Http\Response
     */
    public function delete(Department $department)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.departments.delete')
            ->with('department', $department)
            ->with('title', 'Delete ' . $department->name);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Department $department)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $department->delete();
        return redirect(route('departments.index'))->with('success','Department ' . $department->name . ' deleted successfully!');
    }
}
