<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;
use App\Models\School;
use App\Models\Teacher;
use App\Models\Provider;
use App\Mail\RegistrationWelcomeEmail;
use Illuminate\Support\Facades\Mail;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(RouteServiceProvider::HOME)->with('error','You do not have permission to register users')->with('title', 'Dashboard');
        }
        return view('auth.register')
        ->with('schools', School::orderby('name')->get())
        ->with('providers', Provider::orderby('name')->get())
        ->with('teachers', Teacher::orderby('last_name')->get())
        ->with('title', 'Register Users');
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'lowercase', 'email', 'max:255', 'unique:'.User::class],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'school_id' => $request->school_id,
            'provider_id' => $request->provider_id,
            'teacher_id' => $request->teacher_id,
            'role_id' => $request->role_id,
        ]);
        Mail::to($user->email)->send(new RegistrationWelcomeEmail($request->email, $request->password));

        event(new Registered($user));

        //Auth::login($user);

        return redirect(RouteServiceProvider::HOME);
    }
}
