<?php

namespace App\Http\Controllers;

use App\Models\School;
use App\Http\Requests\StoreSchoolRequest;
use App\Http\Requests\UpdateSchoolRequest;

class SchoolController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }

        $schools = School::all();
        return view('admin.schools.index')
            ->with('title', 'Schools')
            ->with('schools', $schools);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.schools.form')
        ->with('action', 'create')
        ->with('title', 'Create School');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreSchoolRequest $request)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        School::create($request->all());
        return redirect(route('schools.index'))->with('success','School created successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(School $school)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.schools.show')
        ->with('title', $school->name)
        ->with('school', $school)
        ->with('students', $school->students);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(School $school)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.schools.form')
        ->with('action', 'edit')
        ->with('title', 'Edit ' . $school->name)
        ->with('school', $school);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateSchoolRequest $request, School $school)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $school->update($request->all());
        return redirect(route('schools.index'))->with('success','School ' . $school->name . ' updated successfully!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\School  $school
     * @return \Illuminate\Http\Response
     */
    public function delete(School $school)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.schools.delete')
        ->with('title', 'Delete ' . $school->name . '?')
        ->with('school', $school);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\School  $school
     * @return \Illuminate\Http\Response
     */
    public function destroy(School $school)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $school->delete();
        return redirect(route('schools.index'))->with('success','School ' . $school->name . ' deleted successfully!');
    }
}
