<?php

namespace App\Http\Controllers;

use App\Models\Year;
use App\Http\Requests\StoreYearRequest;
use App\Http\Requests\UpdateYearRequest;

class YearController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $years = Year::all();
        return view('admin.years.index')
            ->with('title', 'Years')
            ->with('years', $years);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.years.form')
        ->with('action', 'create')
        ->with('title', 'Create Year');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreYearRequest $request)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $yearDesc = date('Y', strtotime($request->start_date)) . '-' . date('Y', strtotime($request->end_date));
        $request->merge([
            'year' => $yearDesc,
        ]);
        Year::create($request->all());
        return redirect(route('years.index'))->with('success','Year created successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(Year $year)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.years.show', ['year'=>$year])
            ->with('title', 'View ' . $year->year);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Year $year)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.years.form')
            ->with('action', 'edit')
            ->with('title', 'Edit ' . $year->year)
            ->with('year', $year);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateYearRequest $request, Year $year)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $yearDesc = date('Y', strtotime($request->start_date)) . '-' . date('Y', strtotime($request->end_date));
        $request->merge([
            'year' => $yearDesc,
        ]);
        $year->update($request->all());
        return redirect(route('years.index'))->with('success','Year ' . $year->year . ' updated successfully!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Year  $year
     * @return \Illuminate\Http\Response
     */
    public function delete(Year $year)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        return view('admin.years.delete')
            ->with('year', $year)
            ->with('title', 'Delete ' . $year->year);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Year $year)
    {
        if (auth()->user()->role_id != 1) {
            return redirect(route('dashboard'))->with('error','You do not have permission to view this.');
        }
        $year->delete();
        return redirect(route('years.index'))->with('success','Year ' . $year->year . ' deleted successfully!');
    }
}
