<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCourseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|max:100',
            'term' => 'required|max:1',
            'department_id' => 'required|numeric',
            'enrollment_max' => 'required|numeric',
            'course_code' => 'nullable|numeric',
            'minimum_grade' => 'required|numeric',
            'delivery' => 'required|max:1',
            'dual_credit' => 'required|max:1',
            'description' => 'nullable'
        ];
    }
}
