<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreSchoolRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|max:100',
            'mailing_address' => 'nullable|max:100',
            'mailing_city' => 'nullable|max:50',
            'mailing_state' => 'nullable|max:2',
            'mailing_zip' => 'nullable|numeric',
            'mailing_zip4' => 'nullable|numeric',
            'site_address' => 'nullable|max:100',
            'site_city' => 'nullable|max:50',
            'site_state' => 'nullable|max:2',
            'site_zip' => 'nullable|numeric',
            'phone' => 'nullable|max:10',
            'ext' => 'nullable|numeric',
            'fax' => 'nullable|max:10',
            'fax_ext' => 'nullable|numeric',
            'website' => 'nullable|max:50',
            'member_school' => 'required|max:1',
            'notes' => 'nullable'
        ];
    }
}
