<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Section;
use App\Models\Student;

class UpdateEnrollmentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'year_id' => 'required|numeric|exists:years,id',
            'student_id' => [
                'required',
                'numeric',
                'exists:students,id',
                function ($attribute, $value, $fail) {
                    $section = Section::find($this->section_id);
                    $student = Student::find($value);
                    if ($section && $student && !empty($section->restricted_school_ids) && !in_array($student->school_id, $section->restricted_school_ids)) {
                        $schoolNames = [];
                        if (in_array(5, $section->restricted_school_ids)) $schoolNames[] = 'BHS';
                        if (in_array(6, $section->restricted_school_ids)) $schoolNames[] = 'CHS';
                        if (in_array(8, $section->restricted_school_ids)) $schoolNames[] = 'LHS';
                        $fail('That section is for ' . implode('/', $schoolNames) . ' students only.');
                    }
                },
            ],
            'section_id' => 'required|numeric|exists:sections,id',
            'dual_credit' => 'required|boolean',
            'status' => 'sometimes|in:A,R,D,W',
            'lms_updated' => 'sometimes|boolean',
            'ps_updated' => 'sometimes|boolean',
        ];
    }
}
