<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateEquipmentCheckOutRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|max:100',
            'check_out_status' => 'required|max:1',
            'check_in_date' => 'nullable|date',
            'check_out_date' => 'nullable|date',
            'student_id' => 'required|numeric',
            'teacher_id' => 'required|numeric',
            'description' => 'nullable',
            'serial_num' => 'max:20',
            'purchase_date' => 'required|date',
            'purchase_price' => 'required|numeric',
            'condition' => 'required|max:1',
            'notes' => 'nullable'
        ];
    }
}
