<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EnrollmentChangeNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $newEnrollments;
    public $droppedEnrollments;

    public function __construct($newEnrollments, $droppedEnrollments)
    {
        $this->newEnrollments = $newEnrollments;
        $this->droppedEnrollments = $droppedEnrollments;
    }

    public function build()
    {
        return $this->view('emails.enrollment-changes')
                    ->subject('Enrollment Changes Notification');
    }
}
