<?php

namespace App\Mail;

use App\Models\Student;
use Illuminate\Mail\Mailable;

class StudentEmailChanged extends Mailable
{
    public $student;

    public function __construct(Student $student)
    {
        $this->student = $student;
    }

    public function build()
    {
        return $this->subject('Student Email Updated')
            ->view('emails.student_email_changed')
            ->with(['student' => $this->student, 'oldEmail' => $this->student->getOriginal('email'), 'newEmail' => $this->student->email]);
    }
}