<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeLetterMail extends Mailable
{
    use Queueable, SerializesModels;

    public $emailContent;  // Changed from content to emailContent to match view
    public $title;

    public function __construct($content, $title)
    {
        $this->emailContent = $content;  // Changed to match view
        $this->title = $title;
    }

    public function build()
    {
        return $this->subject($this->title)
                    ->view('emails.welcome-letter')
                    ->with([
                        'emailContent' => $this->emailContent  // Explicitly passing to view
                    ]);
    }
}
