<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Contact extends Model
{
    use HasFactory;

    protected $fillable = ['first_name', 'last_name', 'school_id', 'position_id', 'email', 'phone', 'ext', 'is_facilitator'];

    public function school(): BelongsTo
    {
        return $this->belongsTo(School::class, 'school_id');
    }

    public function position(): HasOne
    {
        return $this->hasOne(Position::class, 'id', 'position_id');
    }

    public function formattedPhone()
    {
        $phone = $this->phone ?? $this->school->phone ?? null;
        if (!$phone) {
            return null;
        }

        $formatted = preg_replace('/(\d{3})(\d{3})(\d{4})/', '$1-$2-$3', $phone);

        if ($this->ext) {
            $formatted .= ' Ext: ' . $this->ext;
        }

        return $formatted;
    }
}
