<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;
use Illuminate\Support\Facades\DB;


class Provider extends Model
{
    use HasFactory;

    public function sections(): HasMany
    {
        return $this->hasMany(Section::class);
    }

    public function enrollments(): HasManyThrough
    {
        /*return DB::table("enrollments as e")
        ->leftJoin("sections as s", function($join){
            $join->on("e.section_id", "=", "s.id");
        })
        ->leftJoin("providers as p", function($join){
            $join->on("p.id", "=", "s.provider_id");
        })
        ->select("e.*", "p.*", "s.*")
        ->where("p.id", "=", $this->id)
        ->where("e.year_id", "=", $yearid)
        ->get();*/

        return $this->hasManyThrough(Enrollment::class, Section::class, 'provider_id', 'section_id', 'id', 'id');
    }
}
