<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;

class School extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'mailing_address',
        'mailing_city',
        'mailing_state',
        'mailing_zip',
        'mailing_zip4',
        'site_address',
        'site_city',
        'site_state',
        'site_zip',
        'phone',
        'ext',
        'fax',
        'fax_ext',
        'website',
        'member_school',
        'notes'];

    /*public function getContacts()
    {
        return $this->hasMany('App\Contact');
    }*/

    public function students(): HasMany

    {
        return $this->hasMany(Student::class, 'school_id')->where('grade', "<", 13);
    }

    public function contacts(): HasMany

    {
        return $this->hasMany(Contact::class, 'school_id');
    }

    public function enrollments(): HasManyThrough
    {
        return $this->hasManyThrough(Enrollment::class, Student::class)->where('status', 'A');
    }
}
