<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Student extends Model
{
    use HasFactory;

    protected $fillable = [
        'first_name',
        'last_name',
        'school_id',
        'email',
        'dob',
        'phone',
        'grade',
        'gender',
        'ssid',
        'iep',
        'has_504',
        'notes'
    ];

    public function school(): BelongsTo
    {
        return $this->belongsTo(School::class);
    }

    public function enrollments(): HasMany
    {
        return $this->hasMany(Enrollment::class);
    }

    public function getFullNameAttribute(): string
    {
        return "{$this->first_name} {$this->last_name}";
    }

    public function scopeNeedsSSID($query)
    {
        return $query->whereNull('ssid');
    }

    public function scopeInSchool($query, $schoolId)
    {
        return $query->where('school_id', $schoolId);
    }
}
