<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Teacher extends Model
{
    use HasFactory;

    protected $fillable = ['first_name', 'last_name', 'email', 'phone', 'ext'];

    public function courses(): HasMany {
        return $this->hasMany(Course::class, 'teacher_id');
    }

    public function totalEnrollments(): HasMany {
        return $this->courses->hasMany(Enrollment::class, 'course_id');;
    }

    function formattedPhone(){
        $toReturn = NULL;
        if(isset($this->phone)){
            $toReturn = substr($this->phone, 0,  3) . '-' . substr($this->phone, 3,  3) . '-' . substr($this->phone, 6,  4);
        }
        if(isset($this->ext)) {
            $toReturn = $toReturn . ' Ext: ' . $this->ext;
        }
        return $toReturn;
    }

    public function sections()
    {
        return $this->hasMany(Section::class);
    }
}
