<?php

namespace App\Observers;

use App\Models\Student;
use Illuminate\Support\Facades\Mail;
use App\Mail\StudentEmailChanged;

class StudentObserver
{
    public function updated(Student $student)
    {
        if ($student->isDirty('email') && 
            $student->enrollments()->where('status', 'A')
                ->whereHas('section', fn($q) => $q->where('is_moodle', true))
                ->exists()) {
            Mail::to('jason_horner@bismarckschools.org')->send(new StudentEmailChanged($student));
        }
    }
}