<?php

namespace App\Traits;
use App\Models\Section;
use App\Models\Enrollment;
use App\Models\Student;

trait EnrollmentPermissionTrait
{
    public static function checkEnrollmentPermissions($action, $enrollmentId)
    {
        switch ($action) {
            case 'create':
            case 'store':
                // Teachers cannot create or edit enrollments
                if (auth()->user()->role_id == 4) {
                    return false;
                }
                break;
            case 'edit':
            case 'update':
            case 'delete':
            case 'drop':
            case 'destroy':
                if (auth()->user()->role_id == 4) {
                    return false;
                }
                break;
            case 'show':
                switch (auth()->user()->role_id) {
                    case 1:
                        // Super Admin can see all specific enrollments
                        break;
                    case 2:
                        // Provider can see enrollments for sections that are only with their provider
                        if (auth()->user()->provider_id != Section::find(Enrollment::find($enrollmentId)->section_id)->provider_id) {
                            return false;
                        }
                        break;
                    case 3:
                        // School Personnel can see enrollments
                        if (auth()->user()->school_id != Student::find(Enrollment::find($enrollmentId)->student_id)->school_id) {
                            return false;
                        }
                        break;
                    default:
                        // Teachers can only see enrollments to their sections
                        if (auth()->user()->teacher_id != Section::find(Enrollment::find($enrollmentId)->section_id)->teacher_id) {
                            return false;
                        }
                }
                break;
            default:

        }
        return true;
    }
}
