<?php

namespace App\Traits;
use App\Models\Section;
use App\Models\Year;
use App\Models\WelcomeLetter;
use App\Models\Enrollment;
use App\Models\Student;
use Illuminate\Support\Facades\Mail;

trait SendWelcomeLetterEmail
{
    public function sendWelcomeLetterEmail($sectionId, $to, $from, $subject, $body)
    {
        Mail::send([], [], function ($message) use ($sectionId, $to, $from, $subject, $body) {
            $message->to($to)
                    ->from($from)
                    ->subject($subject)
                    ->html($body);

            // Attach the school calendar for school year
            $school_calendar_attachment = Year::find(Section::find($sectionId)->year_id)->school_calendar_attachment;
            $message->attach('uploads/school-calendars/'. $school_calendar_attachment, [
                'as' => $school_calendar_attachment . '.' .  pathinfo($school_calendar_attachment, PATHINFO_EXTENSION),
                'mime' => 'application/pdf',
            ]);

            // THEN add welcome letter attachment(s)
            $welcomeLetter = WelcomeLetter::where('section_id', $sectionId)->first();
            if(isset($welcomeLetter->file1)){
                $filePath = 'uploads/welcome-letter-files/'. $welcomeLetter->file1;
                $fileName = $welcomeLetter->file1_title ?? $welcomeLetter->file1;
                $mimeType = mime_content_type($filePath);
                $message->attach($filePath, [
                    'as' => $fileName . '.' .  pathinfo($welcomeLetter->file1, PATHINFO_EXTENSION),
                    'mime' => $mimeType,
                ]);
            }
            if(isset($welcomeLetter->file2)){
                $filePath = 'uploads/welcome-letter-files/'. $welcomeLetter->file2;
                $fileName = $welcomeLetter->file2_title ?? $welcomeLetter->file2;
                $mimeType = mime_content_type($filePath);
                $message->attach($filePath, [
                    'as' => $fileName . '.' . pathinfo($welcomeLetter->file2, PATHINFO_EXTENSION),
                    'mime' => $mimeType,
                ]);
            }
            if(isset($welcomeLetter->file3)){
                $filePath = 'uploads/welcome-letter-files/'. $welcomeLetter->file3;
                $fileName = $welcomeLetter->file3_title ?? $welcomeLetter->file3;
                $mimeType = mime_content_type($filePath);
                $message->attach($filePath, [
                    'as' => $fileName . '.' . pathinfo($welcomeLetter->file3, PATHINFO_EXTENSION),
                    'mime' => $mimeType,
                ]);
            }
        });
    }
}
