<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('years', function (Blueprint $table) {
            $table->string('school_calendar_attachment')->unique()->nullable()->after('non_member_cost');
            $table->date('auto_email_fall_start_date')->nullable()->after('school_calendar_attachment');
            $table->date('auto_email_fall_end_date')->nullable()->after('auto_email_fall_start_date');
            $table->date('auto_email_spring_start_date')->nullable()->after('auto_email_fall_end_date');
            $table->date('auto_email_spring_end_date')->nullable()->after('auto_email_spring_start_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('years', function (Blueprint $table) {
            Schema::dropIfExists('school_calendar_attachment');
            Schema::dropIfExists('auto_email_fall_start_date');
            Schema::dropIfExists('auto_email_fall_end_date');
            Schema::dropIfExists('auto_email_spring_start_date');
            Schema::dropIfExists('auto_email_spring_end_date');
        });
    }
};
