<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('welcome_letters', function (Blueprint $table) {
            $table->string('file1_title')->nullable()->after('file1');
            $table->string('file2_title')->nullable()->after('file2');
            $table->string('file3_title')->nullable()->after('file3');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('welcome_letters', function (Blueprint $table) {
            Schema::dropIfExists('file1_title');
            Schema::dropIfExists('file2_title');
            Schema::dropIfExists('file3_title');
        });
    }
};
