<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('years', function (Blueprint $table) {
            $table->boolean('is_visible_to_teachers')->default(false)->after('non_member_cost');
        });
    }

    public function down(): void
    {
        Schema::table('years', function (Blueprint $table) {
            $table->dropColumn('is_visible_to_teachers');
        });
    }
};
