@extends('layouts.cork')
@section('title',  $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('contacts.index') }}">Contacts</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
{{ $contact->first_name . ' ' . $contact->last_name }} <br/>
{{ $contact->position->position }}, <a href="{{ route('schools.show', $contact->school_id) }}">{{ $contact->school->name }}</a> <br/>
{{ $contact->email }} <br/>
{{ $contact->school->site_city }}, {{ $contact->school->site_state }} {{ $contact->school->site_zip }} <br/>
@if(isset($contact->phone))Phone: {{ substr($contact->phone, 0,  3) }}-{{ substr($contact->phone, 3,  3) }}-{{ substr($contact->phone, 6,  4) }} @empty($contact->ext)<br/>@endempty
@else
    {{ substr($contact->school->phone, 0, 3) }}-{{ substr($contact->school->phone, 3, 3) }}-{{ substr($contact->school->phone, 6, 4) }}<br/>
@endif  @if(isset($contact->ext)) Ext: {{ $contact->ext }} <br/> @endif
@if($contact->is_facilitator === 'Y')
    <span style="color: #8dbf42;">{{ $contact->first_name }} is a facilitator</span>
@else
    <span style="color: #e7515a;">{{ $contact->first_name }} is NOT a facilitator</span>
@endif

<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href='{{ route("contacts.edit", $contact->id) }}';">Edit Contact</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '{{ route("contacts.delete", $contact->id) }}';">Delete Contact</button>
</p>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
