@extends('layouts.cork')
@section('title',  $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('courses.index') }}">Courses</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
<h5>
Name: {{ $course->name }}<br/>
Term: @if ($course->term === 'Y') Full Year @elseif($course->term === 'F') Fall @else Spring @endif<br/>
Dept: {{ $course->department->name }}<br/>
Minimum Grade: {{ $course->minimum_grade }}<br/>
Delivery: @if ($course->delivery === 'I') ITV @else Online @endif<br/>
Dual Credit: @if ($course->dual_credit === 'Y') Yes @else No @endif
</h5>
</div>

<!-- List Sections -->
@if($course->sections->isEmpty())
<h4>No Sections Found</h4>
@else
<div class="accordion" id="sectionAccordion">
    @foreach($course->sections as $s)
        <h4>{{ $course->sections->count() }} Sections</h4>
        <div class="accordion-item mb-4">
            <h2 class="accordion-header">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $s->id }}" aria-expanded="false" aria-controls="collapse{{ $s->id }}">
                {{ $s->year->year }} ({{ $course->enrollments->count() }} Enrollments)
            </button>
            </h2>
            <div id="collapse{{ $s->id }}" class="accordion-collapse collapse" data-bs-parent="#sectionAccordion">
                <div class="accordion-body">
                    <!-- List Enrollments -->
                    @if($course->enrollments->isEmpty())
                        <h4>No Enrollments Found</h4>
                    @else
                        <h5>{{ $course->enrollments->count() }} Enrollments</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover mb-4">
                                <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>School</th>
                                    <th>Status</th>
                                    <th>LMS Updated?</th>
                                    <th>Dual Credit</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($course->enrollments as $e)
                                    <tr>
                                        <td>{{ $e->student->last_name . ', ' . $e->student->first_name }}</td>
                                        <td>{{ $e->student->school->name }}</td>
                                        <td>@if ($e->status === 'A') Approved  @elseif ($e->status === 'D') Denied @elseif ($e->status === 'R') Dropped @else Waitlist @endif </td>
                                        <td>@if ($e->lms) Yes @else No @endif </td>
                                        <td>@if ($e->dual_credit) Yes @else No @endif </td>
                                        <td><a href="{{ route('enrollments.show', $e->id) }}">View</a> |
                                            <a href="{{ route('enrollments.edit', $e->id) }}">Edit</a> |
                                            <a href="{{ route('enrollments.delete', $e->id) }}">Delete</a></td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endforeach
</div>
@endif
<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href = '{{ route("courses.edit", $course->id) }}';">Edit Course</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '{{ route("courses.delete", $course->id) }}';">Delete Course</button>
</p>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
