@extends('layouts.cork')
@section('title',  $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('courses.index') }}">Courses</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
    Code: {{ $department->code }} <br/>
    Name: {{ $department->name }}
<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href = '{{ route("departments.edit", $department->id) }}';">Edit Department</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '{{ route("departments.delete", $department->id) }}';">Delete Department</button>
</p>
<!-- List Courses -->
@if($department->courses->isEmpty())
    <h4>No Courses Found</h4>
@else
    <div class="accordion" id="accordionExample">
        @foreach($department->courses as $course)
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{$course->id}}" aria-expanded="true" aria-controls="collapse{{$course->id}}">
                    {{ $course->name }} - @if ($course->term === 'Y') Full Year @elseif($course->term === 'F') Fall @else Spring @endif - {{ $course->enrollments()->get()->count() }} enrollments
                </button>
            </h2>
            <div id="collapse{{$course->id}}" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    @if($course->enrollments->isEmpty())
                        <h6>No Enrollments Found</h6>
                    @else
                        <table class="table table-bordered table-hover mb-4">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($course->enrollments as $enrollment)
                                <tr>
                                    <td><a href="{{ route('students.show', $enrollment->student_id) }}">{{ $enrollment->student->last_name . ", "  . $enrollment->student->first_name }}</a></td>
                                    <td>
                                        <a href="{{ route('enrollments.show', $enrollment->id) }}">View</a> |
                                        <a href="{{ route('enrollments.edit', $enrollment->id) }}">Edit</a> |
                                        <a href="{{ route('enrollments.delete', $enrollment->id) }}">Delete</a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    @endif
                </div>
            </div>
        </div>
        @endforeach
    </div>
@endif
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
