@extends('layouts.cork')
@section('title', 'BPS Medical Terminology Upload Preview')

@section('page-css')
    <style>
        .form-group { margin-bottom: 1.5rem; }
        .invalid-feedback { display: block !important; }
        .table-responsive { overflow-x: auto; }
    </style>
@endsection

@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('enrollments.index') }}">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page">Upload Preview</li>
            </ol>
        </nav>
    </div>
@endsection

@section('content')
    <div class="container">
        <h1>Upload Preview</h1>
        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible" role="alert">
                <h6 class="alert-heading mb-1"><i class="bx bx-xs bx-store align-top me-2"></i>Errors!</h6>
                @foreach ($errors->all() as $error)
                    <span>{{ $error }}</span><br>
                @endforeach
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <form action="{{ route('enrollments.bps-medterm-upload') }}" method="POST">
            @csrf
            {{-- REMOVED: <input type="hidden" name="section_id" value="{{ $section->id }}"> --}}

            <h3>New Students to be Created</h3>
            @if ($newStudents)
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>School</th>
                                <th>Section</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($newStudents as $index => $student)
                                <tr>
                                    <td>{{ $student['name'] }}</td>
                                    <td>{{ $student['school'] }}</td>
                                    <td>{{ $student['section'] }}</td>
                                </tr>
                                @foreach ($student['row_data'] as $key => $value)
                                    <input type="hidden" name="new_students[{{ $index }}][{{ $key }}]" value="{{ $value }}">
                                @endforeach
                                <input type="hidden" name="new_students[{{ $index }}][section_id]" value="{{ $student['section_id'] }}">
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p>No new students to be created.</p>
            @endif

            <h3>Existing Students to be Enrolled</h3>
            @if ($existingStudents)
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>School</th>
                                <th>Section</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($existingStudents as $index => $student)
                                <tr>
                                    <td>{{ $student['name'] }}</td>
                                    <td>{{ $student['school'] }}</td>
                                    <td>{{ $student['section'] }}</td>
                                </tr>
                                @foreach ($student['row_data'] as $key => $value)
                                    <input type="hidden" name="existing_students[{{ $index }}][{{ $key }}]" value="{{ $value }}">
                                @endforeach
                                <input type="hidden" name="existing_students[{{ $index }}][section_id]" value="{{ $student['section_id'] }}">
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p>No existing students to be enrolled.</p>
            @endif

            <button type="submit" class="btn btn-primary">Confirm and Process</button>
            <a href="{{ route('enrollments.bps-medterm-upload-form') }}" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
@endsection
