@extends('layouts.cork')
@section('title', 'BPS Medical Terminology Upload Summary')

@section('page-css')
    <style>
        .table-responsive { overflow-x: auto; }
    </style>
@endsection

@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('enrollments.index') }}">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page">Upload Summary</li>
            </ol>
        </nav>
    </div>
@endsection

@section('content')
    <div class="container">
        <h1>Upload Summary</h1>
        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible" role="alert">
                <h6 class="alert-heading mb-1"><i class="bx bx-xs bx-store align-top me-2"></i>Errors!</h6>
                @foreach ($errors->all() as $error)
                    <span>{{ $error }}</span><br>
                @endforeach
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <h3>New Students Created</h3>
        @if ($createdStudents)
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>School</th>
                            <th>Section</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($createdStudents as $student)
                            <tr>
                                <td>{{ $student['id'] }}</td>
                                <td>{{ $student['name'] }}</td>
                                <td>{{ $student['school'] }}</td>
                                <td>{{ $student['section'] }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <p>No new students created.</p>
        @endif

        <h3>Existing Students Enrolled</h3>
        @if ($existingStudents)
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>School</th>
                            <th>Section</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($existingStudents as $student)
                            <tr>
                                <td>{{ $student['id'] }}</td>
                                <td>{{ $student['name'] }}</td>
                                <td>{{ $student['school'] }}</td>
                                <td>{{ $student['section'] }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <p>No existing students enrolled.</p>
        @endif

        <a href="{{ route('enrollments.index') }}" class="btn btn-primary">Back to Enrollments</a>
    </div>
@endsection
