@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link href="/cork/src/plugins/src/flatpickr/flatpickr.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/plugins/src/noUiSlider/nouislider.min.css" rel="stylesheet" type="text/css">

    <link href="/cork/src/assets/css/light/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="/cork/src/assets/css/dark/scrollspyNav.css" rel="stylesheet" type="text/css" />

@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('equipment.index') }}">Equipment</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection

@section('content')
<form method="post" action="@if($action == 'create'){{ route('equipment.store') }} @else {{ route('equipment.update', $equipment->id) }} @endif">
    @csrf
    @if($action == 'edit') @method('PUT') @endif
    <div class="form-group">
        @if (@isset($action) && ($action === 'checkin' || $action === 'checkout'))
            <input type="hidden" name="name" id="name" value="{{ $equipment->name }}" />
        @else
            <label for="name">Name*</label>
            <div class="form-row">
                <div class="col-md-6 mb-4">
                    <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" id="name" aria-describedby="basic-addon3" maxlength="100" @if(isset($equipment->name)) value="{{ $equipment->name }}" @else value="{{ old('name')}}" @endif>
                    @error('name')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('name') }}
                    </div>
                    @enderror
                </div>
            </div>
        @endif

        <label for="department_id">Department*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="department_id" id="department_id" class="form-select @error('department_id') is-invalid @enderror">
                    @foreach ($departments as $department)
                        <option value="{{ $department->id }}" @if (@isset($equipment->department_id) && $department->id === $equipment->department_id) selected @endif>{{ $department->name }}</option>
                    @endforeach
                </select>
                @error('department_id')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('department_id') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="description">Description</label>
        <div class="form-row">
            <div class="col-md-12 mb-4">
                <textarea class="form-control @error('description') is-invalid @enderror" name="description" id="description" aria-describedby="basic-addon3">@if(isset($equipment->description)){{ $equipment->description }}@else{{ old('description')}}@endif</textarea>
                @error('description')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('description') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="model">Model</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('model') is-invalid @enderror" name="model" id="model" aria-describedby="basic-addon3" maxlength="20" @if(isset($equipment->model)) value="{{ $equipment->model }}" @else value="{{ old('model')}}" @endif>
                @error('model')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('model') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="serial_num">Serial Number</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('serial_num') is-invalid @enderror" name="serial_num" id="serial_num" aria-describedby="basic-addon3" maxlength="20" @if(isset($equipment->serial_num)) value="{{ $equipment->serial_num }}" @else value="{{ old('serial_num')}}" @endif>
                @error('serial_num')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('serial_num') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="purchase_date">Purchase Date*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control flatpickr flatpickr-input active @error('purchase_date') is-invalid @enderror" name="purchase_date" id="purchase_date" aria-describedby="basic-addon3" maxlength="10" @if(isset($equipment->purchase_date)) value="{{ $equipment->purchase_date }}" @else value="{{ old('purchase_date')}}" @endif>
                @error('purchase_date')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('purchase_date') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="purchase_price">Purchase Price*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('purchase_price') is-invalid @enderror" name="purchase_price" id="purchase_price" aria-describedby="basic-addon3" maxlength="11" @if(isset($equipment->purchase_price)) value="{{ $equipment->purchase_price }}" @else value="{{ old('purchase_price')}}" @endif>
                @error('purchase_price')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('purchase_price') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="condition">Condition*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="condition" id="condition" class="form-select @error('condition') is-invalid @enderror">
                    <option value="E" @if (@isset($equipment->condition) && 'E' === $equipment->condition) selected @endif>Excellent</option>
                    <option value="G" @if (@isset($equipment->condition) && 'G' === $equipment->condition) selected @endif>Good</option>
                    <option value="F" @if (@isset($equipment->condition) && 'F' === $equipment->condition) selected @endif>Fair</option>
                    <option value="P" @if (@isset($equipment->condition) && 'P' === $equipment->condition) selected @endif>Poor</option>
                    <option value="S" @if (@isset($equipment->condition) && 'S' === $equipment->condition) selected @endif>Scrap</option>
                </select>
                @error('condition')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('condition') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="notes">Notes</label>
        <div class="form-row">
            <div class="col-md-12 mb-4">
                <textarea class="form-control @error('notes') is-invalid @enderror" name="notes" id="notes" aria-describedby="basic-addon3">@if(isset($equipment->notes)){{ $equipment->notes }}@else {{ old('notes')}}@endif</textarea>
                @error('notes')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('notes') }}
                </div>
                @enderror
            </div>
        </div>
        <div class="form-row">
            <div class="input-group mb-4">
                <input type="submit" name="txt" class="mt-4 btn btn-primary">
            </div>
        </div>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
<script src="/cork/src/assets/js/scrollspyNav.js"></script>
<script src="/cork/src/plugins/src/flatpickr/flatpickr.js"></script>
<script>
    var f1 = flatpickr(document.getElementById('purchase_date'));
</script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
