@if (auth()->user()->role_id == 1 || auth()->user()->role_id == 2)
    <div class="widget widget-table-one">
        <div class="widget-heading">
            <h5 class="">PowerSchool Enrollments Needing Updating ({{$powerSchoolEnrollmentsNeedingUpdate->count()}})</h5>
        </div>
        @foreach ($powerSchoolEnrollmentsNeedingUpdate->take(4) as $p)
            <div class="widget-content">
                <div class="transactions-list t-info">
                    <div class="t-item">
                        <div class="t-company-name">
                            <div class="t-icon">
                                <div class="avatar">
                                    <span class="avatar-title">{{ substr($p->student->last_name, 0, 1) }}{{ substr($p->student->first_name, 0, 1) }}</span>
                                </div>
                            </div>
                            <div class="t-name">
                                <h4>{{ $p->student->last_name }}, {{ $p->student->first_name }}</h4>
                                <p class="meta-date">{{ substr($p->section->course->name, 0, 35) }}</p>
                            </div>
                        </div>
                        <div class="t-rate rate-inc">
                            <p><span><a href="{{ route('enrollments.show', $p->id) }}">View</a> |
                                    <a href="{{ route('enrollments.edit', $p->id) }}">Edit</a></span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endif
