@extends('layouts.cork')
@section('title', 'School Enrollment Report')

@section('page-css')
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/src/table/datatable/datatables.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection

@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('reports.index') }}">Reports</a></li>
            <li class="breadcrumb-item active" aria-current="page">School Enrollment Report</li>
        </ol>
    </nav>
</div>
@endsection

@section('content')
    <form method="post" action="{{ route('reports.schoolEnrollmentReportFiltered') }}">
        @csrf
        <div class="form-row input-group ms-2">
            <div class="col-md-1 mb-4">
                <label for="year_id">Year</label>
                <select name="year_id" id="year_id" class="form-select @error('year_id') is-invalid @enderror">
                    @foreach ($years as $year)
                        <option value="{{ $year->id }}" @if (@isset($yearId) && $year->id == $yearId) selected @endif>
                            {{ $year->year }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2 mb-4 ms-2">
                <label for="provider_id">Provider</label>
                <select name="provider_id" id="provider_id" class="form-select @error('provider_id') is-invalid @enderror">
                    <option value="0">-- All --</option>
                    @foreach ($providers as $provider)
                        <option value="{{ $provider->id }}" @if (@isset($providerId) && $provider->id == $providerId) selected @endif>
                            {{ $provider->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2 mb-4 ms-2">
                <label for="department_id">Department</label>
                <select name="department_id" id="department_id" class="form-select @error('department_id') is-invalid @enderror">
                    <option value="0">-- All --</option>
                    @foreach ($departments as $department)
                        <option value="{{ $department->id }}" @if (@isset($departmentId) && $department->id == $departmentId) selected @endif>
                            {{ $department->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2 mb-4 ms-2">
                <label for="school_id">School</label>
                <select name="school_id" id="school_id" class="form-select @error('school_id') is-invalid @enderror">
                    <option value="0">-- All --</option>
                    @foreach ($schools as $school)
                        <option value="{{ $school->id }}" @if (@isset($schoolId) && $school->id == $schoolId) selected @endif>
                            {{ $school->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="grade">Grade</label>
                <select name="grade" id="grade" class="form-select @error('grade') is-invalid @enderror">
                    <option value="0">-- All --</option>
                    @foreach ([9, 10, 11, 12] as $gradeOption)
                        <option value="{{ $gradeOption }}" @if (@isset($grade) && $gradeOption == $grade) selected @endif>
                            {{ $gradeOption }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="status">Status</label>
                <select name="status" id="status" class="form-select @error('status') is-invalid @enderror">
                    <option value="A" @if (@isset($status) && $status == 'A') selected @endif>Approved</option>
                    <option value="D" @if (@isset($status) && $status == 'D') selected @endif>Denied</option>
                    <option value="R" @if (@isset($status) && $status == 'R') selected @endif>Dropped</option>
                    <option value="W" @if (@isset($status) && $status == 'W') selected @endif>Waitlist</option>
                </select>
            </div>
            <div class="col-md-1 mb-4 ms-2 mt-2">
                <button type="submit" class="mt-4 btn btn-primary">Apply</button>
            </div>
            <div class="col-md-2 mb-4 ms-2 mt-2">
                <button type="submit" name="action" value="send" class="mt-4 btn btn-secondary">Send Filtered Report</button>
            </div>
        </div>
    </form>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">School Enrollment Report</h4>
                    <form action="{{ route('reports.sendSchoolEnrollmentReports') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-primary">Send Report to All Schools</button>
                    </form>
                </div>
                <div class="card-body">
                    @foreach($reportData as $schoolId => $schoolData)
                        <h5>{{ $schoolData['name'] }}</h5>
                        @if(count($schoolData['enrollments']) > 0)
                            <table class="table table-bordered mb-4 dt-table-hover">
                                <thead>
                                    <tr>
                                        <th>Last Name</th>
                                        <th>First Name</th>
                                        <th>Section</th>
                                        <th>Teacher</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($schoolData['enrollments'] as $enrollment)
                                        <tr>
                                            <td>{{ $enrollment['last_name'] }}</td>
                                            <td>{{ $enrollment['first_name'] }}</td>
                                            <td>{{ $enrollment['section'] }}</td>
                                            <td>{{ $enrollment['teacher'] }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @else
                            <p>No approved enrollments for this school.</p>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection

@section('page-js')
    <script src="/cork/src/plugins/src/table/datatable/datatables.js"></script>
    <script>
        $('.table').DataTable({
            "dom": "<'dt--top-section'<'row'<'col-12 col-sm-6 d-flex justify-content-sm-start justify-content-center'l><'col-12 col-sm-6 d-flex justify-content-sm-end justify-content-center mt-sm-0 mt-3'f>>>" +
            "<'table-responsive'tr>" +
            "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
            "oLanguage": {
                "oPaginate": { "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>', "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>' },
                "sInfo": "Showing page _PAGE_ of _PAGES_",
                "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                "sSearchPlaceholder": "Search...",
                "sLengthMenu": "Results :  _MENU_",
            },
            "stripeClasses": [],
            "lengthMenu": [7, 10, 20, 50],
            "pageLength": 10
        });
    </script>
@endsection
