@extends('layouts.cork')

@section('title', 'School Enrollment Summary Report')

@section('content')
    <!-- Filter Form (POST for filtered data) -->
    <form method="POST" action="{{ route('reports.schoolEnrollmentSummaryFiltered') }}">
        @csrf
        <div class="form-row input-group ms-2">
            <div class="col-md-2 mb-4">
                <label for="year">Year</label>
                <select name="year_id" id="year_id" class="form-select @error('year_id') is-invalid @enderror">
                    <option value="">-- All Years --</option>
                    @foreach ($years as $year)
                        <option value="{{ $year->id }}" @if(request('year_id') == $year->id || isset($yearId) && $yearId == $year->id) selected @endif>
                            {{ $year->year }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2 mb-4 ms-2">
                <label for="provider">Provider</label>
                <select name="provider_id" id="provider_id" class="form-select @error('provider_id') is-invalid @enderror">
                    <option value="">-- All Providers --</option>
                    @foreach ($providers as $provider)
                        <option value="{{ $provider->id }}" @if(request('provider_id') == $provider->id || isset($providerId) && $providerId == $provider->id) selected @endif>
                            {{ $provider->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2 mb-4 ms-2">
                <label for="school">School</label>
                <select name="school_id" id="school_id" class="form-select @error('school_id') is-invalid @enderror">
                    <option value="">-- All Schools --</option>
                    @foreach ($schools as $school)
                        <option value="{{ $school->id }}" @if(request('school_id') == $school->id || isset($schoolId) && $schoolId == $school->id) selected @endif>
                            {{ $school->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-1 mb-4 ms-2">
                <button type="submit" class="btn btn-primary mt-4">Apply Filters</button>
            </div>
        </div>
    </form>

    <!-- Display Report Data -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">School Enrollment Summary</h4>
                </div>
                <div class="card-body">
                    @foreach($reportData as $enrollment)
                        <h5>{{ $enrollment->school_name }} ({{ $enrollment->year }})</h5>
                        <table class="table table-bordered mb-4">
                            <thead>
                                <tr>
                                    <th>Fall</th>
                                    <th>Spring</th>
                                    <th>Full Year</th>
                                    <th><strong>Total</strong></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $enrollment->fall_count }}</td>
                                    <td>{{ $enrollment->spring_count }}</td>
                                    <td>{{ $enrollment->full_year_count }}</td>
                                    <td><strong>{{ $enrollment->fall_count + $enrollment->spring_count + $enrollment->full_year_count }}</strong></td>
                                </tr>
                            </tbody>
                        </table>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection
