@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('schools.index') }}">Schools</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection

@section('content')
<form method="post" action="@if($action == 'create'){{ route('schools.store') }} @else {{ route('schools.update', $school->id) }} @endif">
    @csrf
    @if($action == 'edit') @method('PUT') @endif
    <div class="form-group">
        <label for="name">School Name*</label>
        <div class="form-row">
            <div class="col-6 mb-4">
                <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" id="name" aria-describedby="basic-addon3" placeholder="School Name" maxlength="100" @if(isset($school->name)) value="{{ $school->name }}" @else value="{{ old('name')}}" @endif>
                @error('name')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('name') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="mailing_address">Mailing Address</label>
        <div class="form-row">
            <div class="col-6 mb-4">
                <input type="text" class="form-control @error('mailing_address') is-invalid @enderror" name="mailing_address" id="mailing_address" aria-describedby="basic-addon3" placeholder="Mailing Address" maxlength="100" @if(isset($school->mailing_address)) value="{{ $school->mailing_address }}" @else value="{{ old('mailing_address')}}" @endif>
                @error('mailing_address')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('mailing_address') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="mailing_city">Mailing City</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('mailing_city') is-invalid @enderror" name="mailing_city" id="mailing_city" aria-describedby="basic-addon3" placeholder="Mailing City" maxlength="50" @if(isset($school->mailing_city)) value="{{ $school->mailing_city }}" @else value="{{ old('mailing_city')}}" @endif>
                @error('mailing_city')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('mailing_city') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="mailing_state">Mailing State</label>
        <div class="form-row">
            <div class="col-md-3 mb-4">
                <select name="mailing_state" id="mailing_state" class="form-select @error('mailing_state') is-invalid @enderror">
                    <option value="ND" selected>North Dakota</option>
                </select>
                @error('mailing_state')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('mailing_state') }}
                </div>
                @enderror
            </div>
        </div>
        <div class="row">
            <label for="mailing_zip">Mailing Zip & Zip + 4</label>

            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('mailing_zip') is-invalid @enderror" name="mailing_zip" id="mailing_zip" aria-describedby="basic-addon3" placeholder="Mailing Zip" maxlength="5" @if(isset($school->mailing_zip)) value="{{ $school->mailing_zip }}" @else value="{{ old('mailing_zip') }}" @endif>
                @error('mailing_zip')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('mailing_zip') }}
                </div>
                @enderror
            </div> -

            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('mailing_zip4') is-invalid @enderror" name="mailing_zip4" id="mailing_zip4" aria-describedby="basic-addon3" placeholder="Mailing Zip4" maxlength="4" @if(isset($school->mailing_zip4)) value="{{ $school->mailing_zip4 }}" @else value="{{ old('mailing_zip4') }}" @endif>
                @error('mailing_zip4')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('mailing_zip4') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="site_address">Site Address</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('site_address') is-invalid @enderror" name="site_address" id="site_address" aria-describedby="basic-addon3" placeholder="Site Address" maxlength="100" @if(isset($school->site_address)) value="{{ $school->site_address }}" @else value="{{ old('site_address')}}" @endif>
                @error('site_address')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('site_address') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="site_city">Site City</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('site_city') is-invalid @enderror" name="site_city" id="site_city" aria-describedby="basic-addon3" placeholder="Site City" maxlength="50" @if(isset($school->site_city)) value="{{ $school->site_city }}" @else value="{{ old('site_city')}}" @endif>
                @error('site_city')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('site_city') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="site_state">Site State</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="site_state" id="site_state" class="form-select @error('site_state') is-invalid @enderror">
                    <option value="ND" selected>North Dakota</option>
                </select>
                @error('site_state')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('site_state') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="site_zip">Site Zip</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('site_zip') is-invalid @enderror" name="site_zip" id="site_zip" aria-describedby="basic-addon3" placeholder="Site Zip" maxlength="5" @if(isset($school->site_zip)) value="{{ $school->site_zip }}" @else value="{{ old('site_zip') }}" @endif>
                @error('site_zip')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('site_zip') }}
                </div>
                @enderror
            </div>
        </div>
        <div class="row">
            <label for="phone">Phone (format: 7015551234)</label>

            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" id="phone" aria-describedby="basic-addon3" placeholder="Phone" maxlength="10" @if(isset($school->phone)) value="{{ $school->phone }}" @else value="{{ old('phone') }}" @endif>
                @error('phone')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('phone') }}
                </div>
                @enderror
            </div>
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('ext') is-invalid @enderror" name="ext" id="ext" aria-describedby="basic-addon3" placeholder="Ext" maxlength="5" @if(isset($school->ext)) value="{{ $school->ext }}" @else value="{{ old('ext') }}" @endif>
                @error('ext')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('ext') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="website">Website</label>
        <div class="form-row">
            <div class="col-md-4 mb-4">
                <input type="text" class="form-control @error('website') is-invalid @enderror" name="website" id="website" aria-describedby="basic-addon3" placeholder="Website" maxlength="50" @if(isset($school->website)) value="{{ $school->website }}" @else value="{{ old('website') }}" @endif>
                @error('website')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('website') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="row">
            <label for="fax">Fax (format: 7015551234)</label>
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('fax') is-invalid @enderror" name="fax" id="fax" aria-describedby="basic-addon3" placeholder="Fax" maxlength="10" @if(isset($school->fax)) value="{{ $school->fax }}" @else value="{{ old('fax') }}" @endif>
                @error('fax')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('fax') }}
                </div>
                @enderror
            </div>
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('fax_ext') is-invalid @enderror" name="fax_ext" id="fax_ext" aria-describedby="basic-addon3" placeholder="Ext" maxlength="5" @if(isset($school->fax_ext)) value="{{ $school->fax_ext }}" @else value="{{ old('fax_ext') }}" @endif>
                @error('fax_ext')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('fax_ext') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="member_school">Member School?*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <select name="member_school" id="member_school" class="form-select @error('member_school') is-invalid @enderror">
                    <option value="1" @if (@isset($school->member_school) && 1 === $school->member_school) selected @endif>Yes</option>
                    <option value="0" @if (@isset($school->member_school) && 0 === $school->member_school) selected @endif>No</option>
                </select>
                @error('member_school')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('member_school') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="notes">Notes</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <textarea class="form-control" aria-label="With textarea" id="notes" name="notes" placeholder="Student notes...">@if(isset($school->notes)) {{ $school->notes }} @else {{ old('notes')}} @endif</textarea>
                @error('notes')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('notes') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Submit</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary" onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
