@extends('layouts.cork')
@section('title', $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="/cork/src/plugins/src/table/datatable/datatables.css">
    <link rel="stylesheet" href="/cork/src/plugins/css/light/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="/cork/src/plugins/src/table/datatable/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Sections</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
@endsection
@section('content')
    @if (auth()->user()->role_id == 1 || auth()->user()->role_id == 2)
        <button class="btn btn-primary m-2" onclick="window.location.href = '{{ route('sections.create') }}';">+ Add
            Section</button>
    @endif
    <form method="post" action="{{ route('sections.filterSections') }}">
        @csrf
        <div class="form-row input-group ms-2">
            <div class="col-md-1 mb-4 ms-2">
                <label for="year_id">Year</label>
                <select name="year_id" id="year_id" class="form-select @error('year_id') is-invalid @enderror">
                    @foreach ($years as $year)
                        <option value="{{ $year->id }}" @if (@isset($yearid) && $year->id == $yearid) selected @endif>
                            {{ $year->year }}</option>
                    @endforeach
                </select>
                @error('year_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('year_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-2 mb-4 ms-2">
                <label for="department_id">Department</label>
                <select name="department_id" id="department_id"
                    class="form-select @error('department_id') is-invalid @enderror">
                    <option value="0" @if (@isset($departmentId) && 0 == $departmentId) selected @endif>-- All --</option>
                    @foreach ($departments as $dept)
                        <option value="{{ $dept->id }}" @if (@isset($departmentId) && $dept->id == $departmentId) selected @endif>
                            {{ $dept->name }}</option>
                    @endforeach
                </select>
                @error('department_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('department_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="provider_id">Provider</label>
                <select name="provider_id" id="provider_id" class="form-select @error('provider_id') is-invalid @enderror">
                    @if (auth()->user()->role_id == 1)
                        <option value="0" @if (@isset($providerId) && 0 == $providerId) selected @endif>-- All --</option>
                    @endif
                    @foreach ($providers as $provider)
                        <option value="{{ $provider->id }}" @if (@isset($providerId) && $provider->id == $providerId) selected @endif>
                            {{ $provider->name }}</option>
                    @endforeach
                </select>
                @error('provider_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('provider_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-2 mb-4 ms-2">
                <label for="teacher_id">Teacher</label>
                <select name="teacher_id" id="teacher_id" class="form-select @error('teacher_id') is-invalid @enderror">
                    <option value="0" @if (@isset($teacherId) && 0 == $teacherId) selected @endif>-- All --</option>
                    @foreach ($teachers as $t)
                        <option value="{{ $t->id }}" @if (@isset($teacherId) && $t->id == $teacherId) selected @endif>
                            {{ $t->last_name }}, {{ $t->first_name }}
                        </option>
                    @endforeach
                </select>
                @error('teacher_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('teacher_id') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="term">Term</label>
                <select name="term" id="term" class="form-select @error('term') is-invalid @enderror">
                    <option value="A" @if (@isset($term) && 'A' == $term) selected @endif>-- All --</option>
                    <option value="Y" @if (@isset($term) && 'Y' == $term) selected @endif>Full Year</option>
                    <option value="F" @if (@isset($term) && 'F' == $term) selected @endif>Fall</option>
                    <option value="S" @if (@isset($term) && 'S' == $term) selected @endif>Spring</option>
                </select>
                @error('term')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('term') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="dual_credit">Dual Credit</label>
                <select name="dual_credit" id="dual_credit" class="form-select @error('dual_credit') is-invalid @enderror">
                    <option value="A" @if (@isset($dualCredit) && 'A' == $dualCredit) selected @endif>-- All --</option>
                    <option value="0" @if (@isset($dualCredit) && 0 == $dualCredit) selected @endif>No</option>
                    <option value="1" @if (@isset($dualCredit) && 1 == $dualCredit) selected @endif>Yes</option>
                </select>
                @error('dual_credit')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('dual_credit') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="availability">Availability</label>
                <select name="availability" id="availability"
                    class="form-select @error('availability') is-invalid @enderror">
                    <option value="A" @if (@isset($availability) && 'A' == $availability) selected @endif>-- All --</option>
                    <option value="O" @if (@isset($availability) && 'O' == $availability) selected @endif>Open</option>
                    <option value="W" @if (@isset($availability) && 'W' == $availability) selected @endif>Waitlist</option>
                </select>
                @error('availability')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $errors->first('availability') }}
                    </div>
                @enderror
            </div>
            <div class="col-md-1 mb-4 ms-2 mt-2">
                <button type="submit" class="mt-4 btn btn-primary">Apply</button>
            </div>
        </div>
    </form>
    <table id="sections" class="table dt-table-hover" style="width:100%">
        <thead>
            <tr>
                <th>Year</th>
                <th>Course</th>
                <th>Provider</th>
                <th>Enrollments</th>
                <th>Dept</th>
                <th>Term</th>
                <th>Teacher</th>
                <th class="no-content">Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($sections as $s)
                @php $s = App\Models\Section::find($s->id) @endphp
                <tr>
                    <td>{{ $s->year->year }}</td>
                    <td>
                        @if (isset($s->course))
                            {{ $s->course->name }}
                        @endif
                    </td>
                    <td>
                        @if (isset($s->provider->name))
                            {{ $s->provider->name }}
                        @endif
                    </td>
                    <td
                        @if ($s->enrollments->count() >= $s->enrollment_max) style="color:red" @elseif($s->enrollments->count() >= 0.75 * $s->enrollment_max) style="color:#eed202" @else style="color:#00AB66" @endif>
                        @if ($s->enrollments->count() >= $s->enrollment_max && auth()->user()->role_id == 3)
                            Waitlist
                        @else
                            {{ $s->enrollments->count() }} of {{ $s->enrollment_max }}
                        @endif
                    </td>
                    <td>
                        @if (isset($s->course->department->name))
                            {{ $s->course->department->name }}
                        @endif
                    </td>
                    <td>{{ $s->termDesc() }}</td>
                    <td>{{ $s->teacher->last_name . ', ' . substr($s->teacher->first_name, 0, 1) }}</td>
                    <td>
                        <a href="{{ route('sections.show', $s->id) }}"><svg xmlns="http://www.w3.org/2000/svg"
                                height="1em" viewBox="0 0 576 512">
                                <path
                                    d="M288 32c-80.8 0-145.5 36.8-192.6 80.6C48.6 156 17.3 208 2.5 243.7c-3.3 7.9-3.3 16.7 0 24.6C17.3 304 48.6 356 95.4 399.4C142.5 443.2 207.2 480 288 480s145.5-36.8 192.6-80.6c46.8-43.5 78.1-95.4 93-131.1c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C433.5 68.8 368.8 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35.3-28.7 64-64 64c-7.1 0-13.9-1.2-20.3-3.3c-5.5-1.8-11.9 1.6-11.7 7.4c.3 6.9 1.3 13.8 3.2 20.7c13.7 51.2 66.4 81.6 117.6 67.9s81.6-66.4 67.9-117.6c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7c2.1 6.4 3.3 13.2 3.3 20.3z" />
                            </svg></a>&nbsp;
                        @if (auth()->user()->role_id == 1 || auth()->user()->role_id == 2)
                            <a href="{{ route('sections.edit', $s->id) }}"><svg xmlns="http://www.w3.org/2000/svg"
                                    height="1em" viewBox="0 0 512 512">
                                    <path
                                        d="M362.7 19.3L314.3 67.7 444.3 197.7l48.4-48.4c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0zm-71 71L58.6 323.5c-10.4 10.4-18 23.3-22.2 37.4L1 481.2C-1.5 489.7 .8 498.8 7 505s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L421.7 220.3 291.7 90.3z" />
                                </svg></a>&nbsp;
                            @if($s->enrollmentsAnyStatus->count() == 0)
                            <a href="{{ route('sections.delete', $s->id) }}"><svg xmlns="http://www.w3.org/2000/svg"
                                    height="1em" viewBox="0 0 448 512">
                                    <path
                                        d="M135.2 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8c-12.1 0-23.2 6.8-28.6 17.7zM416 128H32L53.2 467c1.6 25.3 22.6 45 47.9 45H346.9c25.3 0 46.3-19.7 47.9-45L416 128z" />
                                </svg></a>
                            @endif
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
    <script src="/cork/src/plugins/src/table/datatable/datatables.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function() {
            var table = $('#sections').DataTable({
                "dom": "<'dt--top-section'<'row'<'col-12 col-sm-6 d-flex justify-content-sm-start justify-content-center'l><'col-12 col-sm-6 d-flex justify-content-sm-end justify-content-center mt-sm-0 mt-3'f>>>" +
                    "<'table-responsive'tr>" +
                    "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
                "oLanguage": {
                    "oPaginate": {
                        "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>',
                        "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>'
                    },
                    "sInfo": "Showing page _PAGE_ of _PAGES_",
                    "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                    "sSearchPlaceholder": "Search...",
                    "sLengthMenu": "Results :  _MENU_",
                },
                "stripeClasses": [],
                "lengthMenu": [25, 50, 75, 100],
                "pageLength": 100,
                "order": [
                    [1, "asc"]
                ]
            });

            // Manually create and add the Excel export button
            var excelButton = $('<button class="btn btn-primary ms-2">Export to Excel</button>');
            $('.dt--top-section .col-sm-6:first-child').append(excelButton);

            excelButton.on('click', function() {
                // Prepare the data
                var data = [
                    // Headers
                    table.columns(':visible').header().toArray().slice(0, 7).map(function(header) {
                        return header.textContent.trim();
                    })
                ];

                // Add row data
                table.rows({
                    search: 'applied'
                }).every(function(rowIdx) {
                    var rowData = this.data();
                    data.push(rowData.slice(0, 7).map(function(cell) {
                        return cell.toString().trim();
                    }));
                });

                // Create a worksheet
                var ws = XLSX.utils.aoa_to_sheet(data);

                // Create a workbook
                var wb = XLSX.utils.book_new();
                XLSX.utils.book_append_sheet(wb, ws, "Sections");

                // Generate Excel file
                XLSX.writeFile(wb, "Sections_Export_" + new Date().toISOString().slice(0, 10) + ".xlsx");
            });
        });
    </script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
