@extends('layouts.cork')
@section('title',  $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('students.index') }}">Students</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
Name: {{ $student->first_name . ' ' . $student->last_name }} <br/>
School: {{ App\Models\School::find($student->school_id)->name }} <br/>
Email: {{ $student->email }} <br/>
DOB: {{ date('m/d/Y', strtotime($student->dob)) }} <br/>
@if(isset($student->phone))Phone: {{ substr($student->phone, 0,  3) }}-{{ substr($student->phone, 3,  3) }}-{{ substr($student->phone, 6,  4) }}<br/>@endif @if(isset($student->ext)) Ext: {{ $student->ext }}<br/>@endif
Grade: {{ $student->grade }} <br/>
Gender: @if ($student->gender === 'M') Male @else Female @endif <br/>
SSID: {{ $student->ssid }} <br/>
IEP?: @if ($student->iep) Yes @else No @endif <br/>
504?: @if ($student->has_504) Yes @else No @endif <br/>

@if(isset($student->notes))Notes: {{ $student->notes }}@endif


<!-- List Enrollments -->
@if($contacts->isEmpty())
<h4 class="mt-4">No School Contacts Found</h4>
@else
<h4 class="mt-4">School Contacts</h4>
<div class="table-responsive">
    <table class="table table-bordered table-hover mb-4">
        <thead>
            <tr>
                <th style="white-space: nowrap">Last Name</th>
                <th style="white-space: nowrap">First Name</th>
                <th style="white-space: nowrap">School</th>
                <th style="white-space: nowrap">Position</th>
                <th style="white-space: nowrap">Email</th>
                <th style="white-space: nowrap">Phone</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($contacts as $contact)
            <tr>
                <td>{{ $contact->last_name }}</td>
                <td>{{ $contact->first_name }}</td>
                <td>{{ $contact->school->name }}</td>
                <td>{{ $contact->position->position }}</td>
                <td>{{ $contact->email }}</td>
                <td>{{ $contact->formattedPhone() }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endif

<!-- List Enrollments -->
@if($student->enrollments->isEmpty())
<h4 class="mt-4">No Enrollments Found</h4>
@else
<h4 class="mt-4">Enrollments</h4>
<div class="table-responsive">
    <table class="table table-bordered table-hover mb-4">
        <thead>
        <tr>
            <th>Year</th>
            <th>Name</th>
            <th>Status</th>
            <th>Dual Credit</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>
        @foreach($student->enrollments as $e)
            @php $e = App\Models\Enrollment::find($e->id) @endphp
            <tr>
                <td>{{ App\Models\Year::find($e->year_id)->year }}
                <td>{{App\Models\Section::find($e->section_id)->course->name }}</td>
                <td>@if ($e->status === 'A') Approved  @elseif ($e->status === 'D') Denied @elseif ($e->status === 'R') Dropped @else Waitlist @endif </td>
                <td>@if ($e->dual_credit === 'Y') Yes @else No @endif </td>
                <td>
                    <a href="{{ route('enrollments.show', $e->id) }}"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 576 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M288 32c-80.8 0-145.5 36.8-192.6 80.6C48.6 156 17.3 208 2.5 243.7c-3.3 7.9-3.3 16.7 0 24.6C17.3 304 48.6 356 95.4 399.4C142.5 443.2 207.2 480 288 480s145.5-36.8 192.6-80.6c46.8-43.5 78.1-95.4 93-131.1c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C433.5 68.8 368.8 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35.3-28.7 64-64 64c-7.1 0-13.9-1.2-20.3-3.3c-5.5-1.8-11.9 1.6-11.7 7.4c.3 6.9 1.3 13.8 3.2 20.7c13.7 51.2 66.4 81.6 117.6 67.9s81.6-66.4 67.9-117.6c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7c2.1 6.4 3.3 13.2 3.3 20.3z"/></svg></a>&nbsp;
                    <a href="{{ route('enrollments.edit', $e->id) }}"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M362.7 19.3L314.3 67.7 444.3 197.7l48.4-48.4c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0zm-71 71L58.6 323.5c-10.4 10.4-18 23.3-22.2 37.4L1 481.2C-1.5 489.7 .8 498.8 7 505s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L421.7 220.3 291.7 90.3z"/></svg></a>&nbsp;
                    @if (auth()->user()->role_id == 1)
                    <a href="{{ route('enrollments.delete', $e->id) }}"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M135.2 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8c-12.1 0-23.2 6.8-28.6 17.7zM416 128H32L53.2 467c1.6 25.3 22.6 45 47.9 45H346.9c25.3 0 46.3-19.7 47.9-45L416 128z"/></svg></a>
                    @endif
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>
@endif

<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href = '{{ route("students.edit", $student->id) }}';">Edit Student</button>
@if($student->enrollments->count() == 0)
<button class="btn btn-danger mb-2" onclick="window.location.href = '{{ route("students.delete", $student->id) }}';">Delete Student</button>
@endif
</p>
</div>

@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
