@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('teachers.index') }}">Teachers</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>

        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection
@section('content')
<form method="POST" action="{{ route('teachers.destroy', $teacher->id) }}">
    @csrf
    @method('DELETE')
    Delete {{ $teacher->first_name . ' ' . $teacher->last_name }}?
    <div class="form-group">
            <input type="submit" name="txt" class="mt-4 mr-5 btn btn-primary" value="Yes, I'm sure">
            <a class="mt-4 btn btn-dark" href="{{ route('teachers.index') }}">Cancel</a>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
