@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('teachers.index') }}">Teachers</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection

@section('content')
<form method="post" action="@if($action == 'create'){{ route('teachers.store') }} @else {{ route('teachers.update', $teacher->id) }} @endif">
    @csrf
    @if($action == 'edit') @method('PUT') @endif
    <div class="form-group">

        <label for="first_name">First Name*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('first_name') is-invalid @enderror" name="first_name" id="first_name" aria-describedby="basic-addon3" placeholder="First Name" maxlength="100" @if(isset($teacher->first_name)) value="{{ $teacher->first_name }}" @else value="{{ old('first_name')}}" @endif>
                @error('first_name')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('first_name') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="last_name">Last Name*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('last_name') is-invalid @enderror" name="last_name" id="last_name" aria-describedby="basic-addon3" placeholder="Last Name" maxlength="100" @if(isset($teacher->last_name)) value="{{ $teacher->last_name }}" @else value="{{ old('last_name')}}" @endif>
                @error('last_name')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('last_name') }}
                </div>
                @enderror
            </div>
        </div>

        <label for="email">Email*</label>
        <div class="form-row">
            <div class="col-md-6 mb-4">
                <input type="text" class="form-control @error('email') is-invalid @enderror" name="email" id="email" aria-describedby="basic-addon3" placeholder="Email" maxlength="50" @if(isset($teacher->email)) value="{{ $teacher->email }}" @else value="{{ old('email')}}" @endif>
                @error('email')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('email') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="row">
            <label for="phone">Phone (format: 7015551234)</label>

            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" id="phone" aria-describedby="basic-addon3" placeholder="Phone" maxlength="10" @if(isset($teacher->phone)) value="{{ $teacher->phone }}" @else value="{{ old('phone') }}" @endif>
                @error('phone')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('phone') }}
                </div>
                @enderror
            </div>
            <div class="col-md-2 mb-4">
                <input type="text" class="form-control @error('ext') is-invalid @enderror" name="ext" id="ext" aria-describedby="basic-addon3" placeholder="Ext" maxlength="5" @if(isset($teacher->ext)) value="{{ $teacher->ext }}" @else value="{{ old('ext') }}" @endif>
                @error('ext')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('ext') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <div class="input-group mb-4">
                <input type="submit" name="txt" class="mt-4 btn btn-primary">
            </div>
        </div>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
