@extends('layouts.cork')
@section('title',  $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/css/selectize.bootstrap5.min.css" integrity="sha512-Ars0BmSwpsUJnWMw+KoUKGKunT7+T8NGK0ORRKj+HT8naZzLSIQoOSIIM3oyaJljgLxFi0xImI5oZkAWEFARSA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('enrollments.index') }}">Enrollments</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection

@section('content')
<form method="post" action="@if($action == 'create'){{ route('enrollments.store') }} @else {{ route('enrollments.update', $enrollment->id) }} @endif">
    @csrf
    @if($action == 'edit') @method('PUT') @endif
    <div class="form-group">
        <label for="file">File*</label>
        <div class="form-row">
            <div class="col-md-2 mb-4">
                <input type="file" name="file" accept=".csv" required>
                @error('file')
                <div class="invalid-feedback" style="display: block !important;">
                    {{ $errors->first('file') }}
                </div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Import CSV</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary" onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </div>
</form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js" integrity="sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.js" integrity="sha512-TCP0r/hsoR3XYFxxMqmxeCZSmHWkjdBiAGy+0xcQ+JU0hOBZMHho7O0x/bXZUf3DH6kcbGhuZFxONYXxMzd7EA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    $('#file').on('change', function(event) {
        $("#updatedSectionList").load('/admin/sections/sections-by-term/year/' + document.getElementById("file").value + '/provider/' + document.getElementById("provider_id").value + '/term/' + document.getElementById("term").value);
        $('#section_id').selectize();
    });
    $('#provider_id').on('change', function(event) {
        $("#updatedSectionList").load('/admin/sections/sections-by-term/year/' + document.getElementById("file").value + '/provider/' + document.getElementById("provider_id").value  + '/term/' + document.getElementById("term").value);
        $('#section_id').selectize();
    });
    $('#term').on('change', function(event) {
        $("#updatedSectionList").load('/admin/sections/sections-by-term/year/' + document.getElementById("file").value + '/provider/' + document.getElementById("provider_id").value + '/term/' + document.getElementById("term").value);
        $('#section_id').selectize();
    });
    $( document ).ready(function() {
        $("#jh").load('/admin/enrollments/show-hide-dual-credit/section/' + document.getElementById("section_id").value );
        $('#section_id').selectize();
    });
    $('#section_id').on('change', function(event) {
        $("#jh").load('/admin/enrollments/show-hide-dual-credit/section/' + document.getElementById("section_id").value );
        $('#section_id').selectize();
    });

</script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
