@extends('layouts.cork')
@section('title',  $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Users</li>
        </ol>
    </nav>
</div>
<!-- /BREADCRUMB -->
@endsection
@section('content')
<button class="btn btn-primary m-2" onclick="window.location.href = '{{ route('register') }}';">+ Add User</button>

<table id="users" class="table dt-table-hover" style="width:100%">
    <thead>
        <tr>
            <th>Name</th>
            <th>School</th>
            <th>Email</th>
            <th class="no-content">Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($users as $user)
        <tr>
            <td>{{ $user->name }}</td>
            <td>@if(isset($user->school)) {{ $user->school->name }} @endif</td>
            <td>@if(isset($user->email)) {{ $user->email }} @endif</td>
            <td></td> 
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
<script src="/cork/src/plugins/src/table/datatable/datatables.js"></script>

@endsection
<!--  END PAGE SCRIPTS FILE  -->

