@extends('layouts.cork')
@section('title', $title)

@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }

        .table-container {
            margin-bottom: 20px;
        }

        .warning-banner {
            background-color: #fff3cd;
            border: 1px solid #ffeeba;
            color: #856404;
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 4px;
            font-weight: bold;
        }

        .facilitator-list {
            list-style-type: none;
            padding-left: 0;
        }

        .facilitator-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }

        .facilitator-name {
            margin-right: 10px;
        }
    </style>
@endsection

@section('content')
    <form method="post" action="{{ route('welcome-letters.bulk-send-confirm', $welcomeLetter->id) }}"
        enctype="multipart/form-data">
        @csrf

        <div class="table-container">
            <h3>Students</h3>
            <table id="students-table" class="table dt-table-hover" style="width:100%">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="select-all-students"></th>
                        <th>Name</th>
                        <th>School</th>
                        <th>Email</th>
                        <th>Sent?</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($enrollments as $e)
                        <tr>
                            <td><input type="checkbox" name="enrollments[]" value="{{ $e->id }}"></td>
                            <td>{{ $e->student->first_name }} {{ $e->student->last_name }}</td>
                            <td>{{ $e->student->school->name }}</td>
                            <td>{{ $e->student->email }}</td>
                            <td>
                                @if ($e->sent_welcome_letter)
                                    <span class="badge badge-success">Yes</span>
                                @else
                                    <span class="badge badge-danger">No</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="warning-banner">
            ⚠️ Warning: Facilitator bulk send functionality is currently in testing. Please use with caution.
        </div>

        <div class="table-container">
            <h3>Facilitators</h3>
            <table id="facilitators-table" class="table dt-table-hover" style="width:100%">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="select-all-facilitators"></th>
                        <th>School</th>
                        <th>Facilitators</th>
                        <th>Sent?</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $groupedFacilitators = $facilitators->groupBy('school_name');
                    @endphp
                    @foreach ($groupedFacilitators as $schoolName => $schoolFacilitators)
                        <tr>
                            <td>
                                {{-- Change checkbox to include all facilitator IDs for this school --}}
                                @foreach ($schoolFacilitators as $f)
                                    <input type="checkbox" name="facilitators[]" value="{{ $f->id }}" class="school-checkbox" style="display: none;">
                                @endforeach
                                {{-- This is the visible checkbox that controls the hidden ones --}}
                                <input type="checkbox" class="school-checkbox-visible">
                            </td>
                            <td>{{ $schoolName }}</td>
                            <td>
                                <ul class="facilitator-list">
                                    @foreach ($schoolFacilitators as $f)
                                        <li class="facilitator-item">
                                            <span class="facilitator-name">
                                                {{ $f->first_name }} {{ $f->last_name }}
                                            </span>
                                            <span class="facilitator-email">{{ $f->email }}</span>
                                        </li>
                                    @endforeach
                                </ul>
                            </td>
                            <td>
                                @if ($schoolFacilitators->first()->sent_copy)
                                    <span class="badge badge-success">Yes</span>
                                @else
                                    <span class="badge badge-danger">No</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="form-row">
            <button type="submit" class="btn btn-primary">Send Emails</button>
            <button type="button" class="btn btn-secondary ml-2"
                onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </form>
@endsection

@section('page-js')
    <script>
$(document).ready(function() {
    // Handle select all students
    $('#select-all-students').on('change', function() {
        var isChecked = $(this).prop('checked');
        $('input[name="enrollments[]"]').prop('checked', isChecked);
    });

    // Update select all checkbox when individual students are checked/unchecked
    $('input[name="enrollments[]"]').on('change', function() {
        var allChecked = $('input[name="enrollments[]"]').length === $('input[name="enrollments[]"]:checked').length;
        $('#select-all-students').prop('checked', allChecked);
    });

    // Handle select all facilitators
    $('#select-all-facilitators').on('change', function() {
        var isChecked = $(this).prop('checked');
        $('.school-checkbox-visible').prop('checked', isChecked).trigger('change');
    });

    // When visible school checkbox is clicked
    $('.school-checkbox-visible').on('change', function() {
        var isChecked = $(this).prop('checked');
        // Find all hidden facilitator checkboxes in this row
        $(this).closest('td').find('input[name="facilitators[]"]').prop('checked', isChecked);
        
        // Update select all checkbox
        var allChecked = $('.school-checkbox-visible:checked').length === $('.school-checkbox-visible').length;
        $('#select-all-facilitators').prop('checked', allChecked);
    });
});
    </script>
@endsection
