@extends('layouts.cork')
@section('title', $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link href="/cork/src/assets/css/light/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/cork/src/plugins/css/light/editors/markdown/simplemde.min.css">
    <link href="/cork/src/assets/css/dark/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/editors/markdown/simplemde.min.css">
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('welcome-letters.index') }}">Welcome Letters</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
@endsection

@section('content')
    <form method="post"
        action="@if ($action == 'create') {{ route('welcome-letters.store') }} @else {{ route('welcome-letters.update', $welcomeLetter->id) }} @endif"
        enctype="multipart/form-data">
        @csrf
        @if ($action == 'edit')
            @method('PUT')
        @endif
        <div class="form-group">

            <label for="section_id">Section*</label>
            <div class="form-row">
                <div class="col-md-4 mb-4" id="section_id">
                    <select name="section_id" id="section_id" class="form-select @error('section_id') is-invalid @enderror">
                        @foreach ($sections as $s)
                            @php $s = App\Models\Section::find($s->id); @endphp
                            <option value="{{ $s->id }}" @if (@isset($welcomeLetter->section_id) && $s->id === $welcomeLetter->section_id) selected @endif>
                                {{ $s->provider->name }} - {{ $s->course->name }} - {{ $s->teacher->last_name }} -
                                {{ $s->year->year }} {{ $s->termDesc() }}</option>
                        @endforeach
                    </select>

                    @error('section_id')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('section_id') }}
                        </div>
                    @enderror
                </div>
            </div>
            <label for="section_id">Text*</label>
            <div class="form-row">
                <div class="col-md-8 mb-4" id="text-div">
                    <textarea id="text" name="text">
                        @if (isset($welcomeLetter->text))
{{ $welcomeLetter->text }}
@else
{{ old('text') }}
@endif
                    </textarea>
                </div>
            </div>
            <button class="btn btn-outline-info mb-2 me-4" style="text-align: left">You may add up to 3 attachments that
                automatically send with
                your
                welcome letter
                (syllabus, materials
                list,
                etc.). Give each file a title as that is
                what the files will be named as on the email attachments. <strong>No need to attach the calendar as that
                    will be done
                    automatically.</strong></button>
            <label for="file1">File 1</label>
            <div class="form-row">
                @if (isset($welcomeLetter->file1))
                    <div class="col-md-8 mb-4" id="file1Link">
                        <p>Current File: <a
                                href="/uploads/welcome-letter-files/{{ $welcomeLetter->file1 }}">{{ $welcomeLetter->file1 }}</a>
                        </p>
                        <input type="hidden" id="file1_old" name="file1_old" value="{{ $welcomeLetter->file1 }}" />
                        <button type="button" onclick="toggleFile1()">Remove File</button>
                    </div>
                    <div class="col-md-8 mb-4" id="file1Upload"
                        style="{{ isset($welcomeLetter->file1) ? 'display: none;' : '' }}">
                        <input type="file" name="file1" id="file1" />
                    </div>
                @else
                    <div class="col-md-8 mb-4" id="file1Upload">
                        <input type="file" name="file1" id="file1" />
                    </div>
                @endif
                <div class="form-row">
                    <label for="file1_title">File 1 Title</label>
                    <div class="col-md-4 mb-4">
                        <input type="text" class="form-control @error('file1_title') is-invalid @enderror"
                            name="file1_title" id="file1_title" aria-describedby="basic-addon3" placeholder="File 1 Title"
                            maxlength="100"
                            @if (isset($welcomeLetter->file1_title)) value="{{ $welcomeLetter->file1_title }}" @else value="{{ old('file1_title') }}" @endif>
                        @error('file1_title')
                            <div class="invalid-feedback" style="display: block !important;">
                                {{ $errors->first('file1_title') }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        <label for="file2">File 2</label>
        <div class="form-row">
            @if (isset($welcomeLetter->file2))
                <div class="col-md-8 mb-4" id="file2Link">
                    <p>Current File: <a
                            href="/uploads/welcome-letter-files/{{ $welcomeLetter->file2 }}">{{ $welcomeLetter->file2 }}</a>
                    </p>
                    <input type="hidden" id="file2_old" name="file2_old" value="{{ $welcomeLetter->file2 }}" />
                    <button type="button" onclick="toggleFile2()">Remove File</button>
                </div>
                <div class="col-md-8 mb-4" id="file2Upload"
                    style="{{ isset($welcomeLetter->file2) ? 'display: none;' : '' }}">
                    <input type="file" name="file2" id="file2" />
                </div>
            @else
                <div class="col-md-8 mb-4" id="file2Upload">
                    <input type="file" name="file2" id="file2" />
                </div>
            @endif
            <div class="form-row">
                <label for="file2_title">File 2 Title</label>
                <div class="col-md-4 mb-4">
                    <input type="text" class="form-control @error('file2_title') is-invalid @enderror"
                        name="file2_title" id="file2_title" aria-describedby="basic-addon3" placeholder="File 2 Title"
                        maxlength="100"
                        @if (isset($welcomeLetter->file2_title)) value="{{ $welcomeLetter->file2_title }}" @else value="{{ old('file2_title') }}" @endif>
                    @error('file2_title')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('file2_title') }}
                        </div>
                    @enderror
                </div>
            </div>
        </div>
        <label for="file3">File 3</label>
        <div class="form-row">
            @if (isset($welcomeLetter->file3))
                <div class="col-md-8 mb-4" id="file3Link">
                    <p>Current File: <a
                            href="/uploads/welcome-letter-files/{{ $welcomeLetter->file3 }}">{{ $welcomeLetter->file3 }}</a>
                    </p>
                    <input type="hidden" id="file3_old" name="file3_old" value="{{ $welcomeLetter->file3 }}" />
                    <button type="button" onclick="toggleFile3()">Remove File</button>
                </div>
                <div class="col-md-8 mb-4" id="file3Upload"
                    style="{{ isset($welcomeLetter->file3) ? 'display: none;' : '' }}">
                    <input type="file" name="file3" id="file3" />
                </div>
            @else
                <div class="col-md-8 mb-4" id="file3Upload">
                    <input type="file" name="file3" id="file3" />
                </div>
            @endif
            <div class="form-row">
                <label for="file3_title">File 3 Title</label>
                <div class="col-md-4 mb-4">
                    <input type="text" class="form-control @error('file3_title') is-invalid @enderror"
                        name="file3_title" id="file3_title" aria-describedby="basic-addon3" placeholder="File 3 Title"
                        maxlength="100"
                        @if (isset($welcomeLetter->file3_title)) value="{{ $welcomeLetter->file3_title }}" @else value="{{ old('file3_title') }}" @endif>
                    @error('file3_title')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $errors->first('file3_title') }}
                        </div>
                    @enderror
                </div>
            </div>

        </div>
        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Submit</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary"
                onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
        </div>
    </form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
    <script src="/cork/src/assets/js/scrollspyNav.js"></script>
    <script src="https://cdn.ckeditor.com/ckeditor5/41.4.1/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#text'))
            .catch(error => {
                console.error(error);
            });

        function toggleFile1() {
            document.getElementById('file1Link').style.display = 'none';
            document.getElementById('file1Upload').style.display = 'block';
        }

        function toggleFile2() {
            document.getElementById('file2Link').style.display = 'none';
            document.getElementById('file2Upload').style.display = 'block';
        }

        function toggleFile3() {
            document.getElementById('file3Link').style.display = 'none';
            document.getElementById('file3Upload').style.display = 'block';
        }
    </script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
