@extends('layouts.cork')
@section('title', $title)

<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
@endsection
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('welcome-letters.index') }}">Welcome Letters</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
            </ol>
        </nav>
    </div>
@endsection
<!-- END BREADCRUMB -->
@section('content')
    <div class="form-row">
        {!! $welcomeLetter->text !!}
    </div>
    @if (isset($welcomeLetter->file1))
        <div class="form-row">
            File 1: <a href="/uploads/welcome-letter-files/{{ $welcomeLetter->file1 }}" target="_blank"
                style="text-decoration: underline !important; color: blue !important">
                @if (isset($welcomeLetter->file1_title))
                    {{ $welcomeLetter->file1_title }}
                @else
                    {{ $welcomeLetter->file1 }}
                @endif
            </a>
        </div>
    @endif
    @if (isset($welcomeLetter->file2))
        <div class="form-row">
            File 2: <a href="/uploads/welcome-letter-files/{{ $welcomeLetter->file2 }}" target="_blank"
                style="text-decoration: underline !important; color: blue !important">
                @if (isset($welcomeLetter->file2_title))
                    {{ $welcomeLetter->file2_title }}
                @else
                    {{ $welcomeLetter->file2 }}
                @endif
            </a>
        </div>
    @endif
    @if (isset($welcomeLetter->file3))
        <div class="form-row">
            File 3: <a href="/uploads/welcome-letter-files/{{ $welcomeLetter->file3 }}" target="_blank"
                style="text-decoration: underline !important; color: blue !important">
                @if (isset($welcomeLetter->file3_title))
                    {{ $welcomeLetter->file3_title }}
                @else
                    {{ $welcomeLetter->file3 }}
                @endif
            </a>
        </div>
    @endif
    <p class="mt-2">
        <button class="btn btn-warning mb-2"
            onclick="window.location.href = '{{ route('welcome-letters.edit', $welcomeLetter->id) }}';">Edit Welcome
            Letter</button> <button class="btn btn-danger mb-2"
            onclick="window.location.href = '{{ route('welcome-letters.delete', $welcomeLetter->id) }}';">Delete Welcome
            Letter</button>
    </p>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')

@endsection
<!--  END PAGE SCRIPTS FILE  -->
