@extends('layouts.cork')
@section('title', $title)


<!-- BEGIN PAGE CSS -->
@section('page-css')
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link href="/cork/src/plugins/src/flatpickr/flatpickr.css" rel="stylesheet" type="text/css">
    <link href="/cork/src/plugins/src/noUiSlider/nouislider.min.css" rel="stylesheet" type="text/css">

    <link href="/cork/src/assets/css/light/scrollspyNav.css" rel="stylesheet" type="text/css" />
    <link href="/cork/src/assets/css/dark/scrollspyNav.css" rel="stylesheet" type="text/css" />
@endsection
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
@section('breadcrumb')
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('students.index') }}">Students</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $title }}</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
@endsection
@section('content')
    <form method="POST" action="{{ route('register') }}">
        @csrf

        <!-- Name -->
        <div class="form-row mt-4">
            <label for="name">Name*</label>
            <div class="form-row">
                <div class="col-md-3 mb-4">
                    <input type="text" class="form-control @error('name') is-invalid @enderror" name="name"
                        id="name" aria-describedby="basic-addon3" maxlength="100" value="{{ old('name') }}" />
                    @error('name')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Email Address -->
        <div class="form-row mt-4">
            <label for="email">Email*</label>
            <div class="form-row">
                <div class="col-md-3 mb-4">
                    <input type="text" class="form-control @error('email') is-invalid @enderror" name="email"
                        id="email" aria-describedby="basic-addon3" maxlength="50" value="{{ old('email') }}" />
                    @error('email')
                        <div class="invalid-feedback" style="display: block !important;">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Password -->
        <div class="form-row mt-4">
            <label for="password">Password*</label>
            <div class="col-md-3 mb-4">
                <input type="password" class="form-control @error('password') is-invalid @enderror" name="password"
                    id="password" aria-describedby="basic-addon3" />
                @error('password')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>

        <!-- Confirm Password -->
        <div class="form-row mt-4">
            <label for="password_confirmation">Confirm Password*</label>
            <div class="col-md-3 mb-4">
                <input type="password" class="form-control @error('password_confirmation') is-invalid @enderror"
                    name="password_confirmation" id="password_confirmation" aria-describedby="basic-addon3" />
                @error('password_confirmation')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>

        <!-- Role -->
        <div class="form-row mt-4">
            <label for="role_id">Role*</label>
            <div class="col-md-3 mb-4">
                <select name="role_id" id="role_id" class="form-select @error('role_id') is-invalid @enderror">
                    <option value="2" {{ old('role_id') == 2 ? 'selected' : '' }}>Provider</option>
                    <option value="3" {{ old('role_id') == 3 ? 'selected' : '' }}>School Personnel</option>
                    <option value="4" {{ old('role_id') == 4 ? 'selected' : '' }}>Teacher</option>
                </select>
                @error('role_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>

        <!-- Provider -->
        <div class="form-row mt-4">
            <label for="provider_id">Provider*</label>
            <div class="col-md-3 mb-4">
                <select name="provider_id" id="provider_id" class="form-select @error('provider_id') is-invalid @enderror">
                    <option value="0" {{ old('provider_id') == 0 ? 'selected' : '' }}>No Provider</option>
                    @foreach ($providers as $provider)
                        <option value="{{ $provider->id }}" {{ old('provider_id') == $provider->id ? 'selected' : '' }}>
                            {{ $provider->name }}
                        </option>
                    @endforeach
                </select>
                @error('provider_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>

        <!-- School -->
        <div class="form-row mt-4">
            <label for="school_id">School*</label>
            <div class="col-md-3 mb-4">
                <select name="school_id" id="school_id" class="form-select @error('school_id') is-invalid @enderror">
                    <option value="0" {{ old('school_id') == 0 ? 'selected' : '' }}>No School</option>
                    @foreach ($schools as $school)
                        <option value="{{ $school->id }}" {{ old('school_id') == $school->id ? 'selected' : '' }}>
                            {{ $school->name }}
                        </option>
                    @endforeach
                </select>
                @error('school_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>

        <!-- Teacher -->
        <div class="form-row mt-4">
            <label for="teacher_id">Teacher*</label>
            <div class="col-md-3 mb-4">
                <select name="teacher_id" id="teacher_id" class="form-select @error('teacher_id') is-invalid @enderror">
                    <option value="0" {{ old('teacher_id') == 0 ? 'selected' : '' }}>No Teacher</option>
                    @foreach ($teachers as $teacher)
                        <option value="{{ $teacher->id }}" {{ old('teacher_id') == $teacher->id ? 'selected' : '' }}>
                            {{ $teacher->last_name }}, {{ $teacher->first_name }}
                        </option>
                    @endforeach
                </select>
                @error('teacher_id')
                    <div class="invalid-feedback" style="display: block !important;">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Submit</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary"
                onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </form>
@endsection
<!--  BEGIN PAGE SCRIPTS FILE  -->
@section('page-js')
    <script src="/cork/src/assets/js/scrollspyNav.js"></script>
    <script src="/cork/src/plugins/src/flatpickr/flatpickr.js"></script>
@endsection
<!--  END PAGE SCRIPTS FILE  -->
