<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Contact {{ $action }} Notification</title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333;">
    <h2>Contact {{ $action }} Notification</h2>
    <p>A contact has been {{ strtolower($action) }} in the system. Below are the details:</p>

    <h3>Contact Information</h3>
    <p><strong>Name:</strong> {{ $contact->first_name }} {{ $contact->last_name }}</p>
    <p><strong>School:</strong> {{ $schoolName }}</p>

    <h3>Affected Sections and Students</h3>
    @if (!empty($sections))
        @foreach ($sections as $section)
            <h4>Section: {{ $section['name'] }}</h4>
            <ul>
                @foreach ($section['students'] as $student)
                    <li>{{ $student->first_name }} {{ $student->last_name }}</li>
                @endforeach
            </ul>
        @endforeach
    @else
        <p>No relevant sections or students found.</p>
    @endif

    <p>If you have any questions, please contact the system administrator.</p>
    <p>Thank you,</p>
    <p>BASC Team</p>
</body>
</html>