<!DOCTYPE html>
<html dir="ltr" lang="en">

<head>

    <!-- Meta Tags -->
    <meta name="viewport" content="width=device-width,initial-scale=1.0" />
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <meta name="description" content="StudyPress | Education & Courses HTML Template" />
    <meta name="keywords" content="academy, course, education, education html theme, elearning, learning," />
    <meta name="author" content="ThemeMascot" />

    <!-- Page Title -->
    <title>CRACTC</title>

    <!-- Favicon and Touch Icons -->
    <link href="frontend/images/favicon.png" rel="shortcut icon" type="image/png">
    <link href="frontend/images/apple-touch-icon.png" rel="apple-touch-icon">
    <link href="frontend/images/apple-touch-icon-72x72.png" rel="apple-touch-icon" sizes="72x72">
    <link href="frontend/images/apple-touch-icon-114x114.png" rel="apple-touch-icon" sizes="114x114">
    <link href="frontend/images/apple-touch-icon-144x144.png" rel="apple-touch-icon" sizes="144x144">

    <!-- Stylesheet -->
    <link href="frontend/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="frontend/css/animate.min.css" rel="stylesheet" type="text/css">
    <link href="frontend/css/javascript-plugins-bundle.css" rel="stylesheet" />

    <!-- CSS | menuzord megamenu skins -->
    <link href="frontend/js/menuzord/css/menuzord.css" rel="stylesheet" />

    <!-- CSS | Main style file -->
    <link href="frontend/css/style-main.css" rel="stylesheet" type="text/css">
    <link id="menuzord-menu-skins" href="frontend/css/menuzord-skins/menuzord-rounded-boxed.css" rel="stylesheet" />

    <!-- CSS | Responsive media queries -->
    <link href="frontend/css/responsive.css" rel="stylesheet" type="text/css">
    <!-- CSS | Style css. This is the file where you can place your own custom css code. Just uncomment it and use it. -->

    <!-- CSS | Theme Color -->
    <link href="frontend/css/colors/theme-skin-color-set1.css" rel="stylesheet" type="text/css">

    <!-- external javascripts -->
    <script src="frontend/js/jquery.js"></script>
    <script src="frontend/js/popper.min.js"></script>
    <script src="frontend/js/bootstrap.min.js"></script>
    <script src="frontend/js/javascript-plugins-bundle.js"></script>
    <script src="frontend/js/menuzord/js/menuzord.js"></script>

    <!-- REVOLUTION STYLE SHEETS -->
    <link rel="stylesheet" type="text/css" href="frontend/js/revolution-slider/css/rs6.css">
    <link rel="stylesheet" type="text/css" href="frontend/js/revolution-slider/extra-rev-slider1.css">
    <!-- REVOLUTION LAYERS STYLES -->
    <!-- REVOLUTION JS FILES -->
    <script src="frontend/js/revolution-slider/js/revolution.tools.min.js"></script>
    <script src="frontend/js/revolution-slider/js/rs6.min.js"></script>
    <script src="frontend/js/revolution-slider/extra-rev-slider1.js"></script>

    <!-- <link href="css/style.css" rel="stylesheet" type="text/css"> -->


    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->
</head>

<body class="tm-container-1340px has-side-panel side-panel-right">
    <!-- preloader -->
    <div id="preloader">
        <div id="spinner">
            <div class="preloader-dot-loading">
                <div class="cssload-loading"><i></i><i></i><i></i><i></i></div>
            </div>
        </div>
        <div id="disable-preloader" class="btn btn-default btn-sm bg-white-f5">Disable Preloader</div>
    </div>
    <div class="side-panel-body-overlay"></div>
    <div id="side-panel-container" class="dark" data-tm-bg-img="frontend/images/side-push-bg.jpg">
        <div class="side-panel-wrap">
            <div id="side-panel-trigger-close" class="side-panel-trigger"><a href="#"><i
                        class="fa fa-times side-panel-trigger-icon"></i></a></div>
            <img class="logo mb-50" src="frontend/images/logo-wide.png" alt="Logo">
            <p>Our motive is to help the poor, helpless and orphan children all over the world.</p>
            <div class="widget">
                <h4 class="widget-title widget-title-line-bottom line-bottom-theme-colored1">Latest News</h4>
                <div class="latest-posts">
                    <article class="post clearfix pb-0 mb-10">
                        <a class="post-thumb" href="#"><img src="https://placehold.it/75x75" alt=""></a>
                        <div class="post-right">
                            <h5 class="post-title mt-0"><a href="#">Sustainable Construction</a></h5>
                            <p>Lorem ipsum dolor...</p>
                        </div>
                    </article>
                    <article class="post clearfix pb-0 mb-10">
                        <a class="post-thumb" href="#"><img src="https://placehold.it/75x75" alt=""></a>
                        <div class="post-right">
                            <h5 class="post-title mt-0"><a href="#">Industrial Coatings</a></h5>
                            <p>Lorem ipsum dolor...</p>
                        </div>
                    </article>
                    <article class="post clearfix pb-0 mb-10">
                        <a class="post-thumb" href="#"><img src="https://placehold.it/75x75" alt=""></a>
                        <div class="post-right">
                            <h5 class="post-title mt-0"><a href="#">Storefront Installations</a></h5>
                            <p>Lorem ipsum dolor...</p>
                        </div>
                    </article>
                </div>
            </div>

            <div class="widget">
                <h5 class="widget-title widget-title-line-bottom line-bottom-theme-colored1">Contact Info</h5>
                <div class="tm-widget-contact-info contact-info-style1 contact-icon-theme-colored1">
                    <ul>
                        <li class="contact-name">
                            <div class="icon"><i class="flaticon-contact-037-address"></i></div>
                            <div class="text">John Doe</div>
                        </li>
                        <li class="contact-phone">
                            <div class="icon"><i class="flaticon-contact-042-phone-1"></i></div>
                            <div class="text"><a href="tel:+510-455-6735">+510-455-6735</a></div>
                        </li>
                        <li class="contact-email">
                            <div class="icon"><i class="flaticon-contact-043-email-1"></i></div>
                            <div class="text"><a href="mailto:info@yourdomain.com">info@yourdomain.com</a></div>
                        </li>
                        <li class="contact-address">
                            <div class="icon"><i class="flaticon-contact-047-location"></i></div>
                            <div class="text">3982 Browning Lane Carolyns Circle, California</div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div id="wrapper" class="clearfix">
        <!-- Header -->
        <header id="header" class="header header-layout-type-header-2rows">
            <div class="header-top">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-auto header-top-left align-self-center text-center text-xl-start">
                            <ul class="element contact-info">
                                <li class="contact-phone"><i class="fa fa-phone font-icon sm-display-block"></i> Tel:
                                    701-415-0453</li>
                                <li class="contact-email"><i class="fa fa-envelope font-icon sm-display-block"></i>
                                    cractc.online@k12.nd.us</li>
                                <li class="contact-address"><i class="fa fa-map font-icon sm-display-block"></i> 1929
                                    N Washington St. Suite A &bull; Bismarck, ND 58501</li>
                            </ul>
                        </div>
                        <div class="col-xl-auto ms-xl-auto header-top-right align-self-center text-center text-xl-end">
                            <div class="element pt-0 pb-0">
                                <ul class="styled-icons icon-dark icon-theme-colored1 icon-circled clearfix">
                                    <li><a class="social-link" href="https://facebook.com/CRACTC1" target="_blank"><i
                                                class="fab fa-facebook"></i></a></li>
                                    <li><a class="social-link" href="https://twitter.com/cractc1" target="_blank"><i
                                                class="fab fa-twitter"></i></a></li>
                                    <!--<li><a class="social-link" href="#" ><i class="fab fa-youtube"></i></a></li>-->
                                </ul>
                            </div>
                            <div class="element pt-0 pt-lg-10 pb-0">
                                <a href="https://moodle.cractc.org"
                                    class="btn btn-theme-colored2 btn-sm ajaxload-popup">Moodle</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="header-nav tm-enable-navbar-hide-on-scroll">
                <div class="header-nav-wrapper navbar-scrolltofixed">
                    <div class="menuzord-container header-nav-container">
                        <div class="container position-relative">
                            <div class="row header-nav-col-row">
                                <div class="col-sm-auto align-self-center">
                                    <a class="menuzord-brand site-brand" href="index-mp-layout1.html">
                                        <img class="logo-default logo-1x" src="frontend/images/logo-wide.png"
                                            alt="Logo">
                                        <img class="logo-default logo-2x retina"
                                            src="frontend/images/logo-wide@2x.png" alt="Logo">
                                    </a>
                                </div>
                                <div class="col-sm-auto ms-auto pr-0 align-self-center">
                                    <nav id="top-primary-nav" class="menuzord theme-color1" data-effect="slide"
                                        data-animation="none" data-align="right">
                                        <ul class="menuzord-menu onepage-nav">
                                            <li class="active"><a href="#home">Home</a></li>
                                            <li><a href="#courses">Courses</a></li>
                                            <li><a href="#adminInfo">Admin Info</a></li>
                                            <li><a href="#studentCorner">Student Corner</a></li>
                                            <li><a href="#ourTeam">Our Team</a></li>
                                            <li><a href="#gallery">Gallery</a></li>
                                            <li><a href="#contact">Contact</a></li>
                                            <li><a href="https://moodle.cractc.org">Moodle</a></li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Start main-content -->
        <div class="main-content-area">
            <!-- Section: home -->
            <section id="home" class="">
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col">
                            <!-- START StudyPress HTML RevSlider REVOLUTION SLIDER 6.1.7 -->
                            <p class="rs-p-wp-fix"></p>
                            <rs-module-wrap id="rev_slider_1_1_wrapper" data-alias="studypress-html-revslider-1"
                                data-source="gallery"
                                style="background:transparent;padding:0;margin:0px auto;margin-top:0;margin-bottom:0;">
                                <rs-module id="rev_slider_1_1" style="display:none;" data-version="6.1.7">
                                    <rs-slides>
                                      <rs-slide data-key="rs-48" data-title="Who We Are"
                                            data-thumb="frontend/images/bg/bg2.jpg"
                                            data-anim="ei:d;eo:d;s:d;r:0;t:slotslide-horizontal;sl:d;">
                                            <img src="frontend/images/front/carousel/it.jpg" title="Who We Are"
                                                width="1920" height="1078" data-parallax="off"
                                                class="rev-slidebg" data-no-retina>
                                            <!--
                                            <rs-layer id="slider-10-slide-48-layer-1" data-type="text"
                                                data-rsp_ch="on" data-xy="x:c;yo:447px,400px,364px,312px;"
                                                data-text="w:normal;s:20,18,18,16;l:25,28,28,26;fw:300;a:center;"
                                                data-frame_1="st:900;sp:1000;" data-frame_999="o:0;st:w;sR:8700;"
                                                style="z-index:9;">CRACTC is a “Virtual” Career and Technical Center established in 2008 as a partnership between the
                                                CREA –Central Regional Education Association and Bismarck Public Schools.
                                            </rs-layer>
                                            -->
                                            <rs-layer id="slider-10-slide-48-layer-2" data-type="text"
                                                data-rsp_ch="on" data-xy="x:c;yo:226px,212px,179px,153px;"
                                                data-text="w:normal;s:115,100,95,78;l:115,89,90,71;ls:1px,0px,0px,0px;fw:700;a:left,left,left,center;"
                                                data-frame_1="st:300;sp:1000;sR:310;"
                                                data-frame_999="o:0;st:w;sR:7690;"
                                                style="z-index:11;text-transform:uppercase;">Who We Are
                                            </rs-layer>
                                            <rs-layer id="slider-10-slide-48-layer-3" data-type="text"
                                                data-rsp_ch="on" data-xy="x:c;yo:364px,323px,291px,245px;"
                                                data-text="w:normal;s:36,32,28,24;l:25,21,25,30;fw:600;a:left,left,left,center;"
                                                data-padding="t:15,15,11,7;r:30,20,15,15;b:15,15,11,7;l:30,20,15,15;"
                                                data-border="bos:solid;boc:#f2184f;bow:0,6px,0,6px;bor:50px,50px,50px,50px;"
                                                data-frame_1="st:600;sp:1000;sR:500;"
                                                data-frame_999="o:0;st:w;sR:7500;"
                                                style="z-index:10;background-color:#202c45;">
                                                CRACTC is a “Virtual” Career and Technical Center established<br/><br/>
                                                in 2008 as a partnership between the CREA –Central Regional <br/><br/>
                                                Education Association and Bismarck Public Schools.
                                            </rs-layer>
                                            <!--
                                            <rs-layer id="slider-10-slide-48-layer-4" data-type="text"
                                                data-rsp_ch="on" data-xy="x:c;yo:539px,481px,448px,390px;"
                                                data-text="w:normal;s:18,14,18,20;l:25,19,18,22;a:left,left,left,center;"
                                                data-border="bos:solid;boc:#f2184f;bow:0,0,0,6px;"
                                                data-frame_1="st:1200;sp:1000;sR:1500;"
                                                data-frame_999="o:0;st:w;sR:6500;" style="z-index:8;"><a
                                                    href="#"
                                                    class="btn btn-flat btn-theme-colored2 text-white">Get a Free
                                                    Quote</a>
                                            </rs-layer>
                                            -->
                                        </rs-slide>
                                        <rs-slide data-key="rs-47" data-title="Our Mission"
                                            data-thumb="frontend/images/front/carousel/ag.jpg"
                                            data-anim="ei:d;eo:d;s:d;r:0;t:slotslide-horizontal;sl:d;">
                                            <img src="frontend/images/front/carousel/ag.jpg" title="Our Mission"
                                                width="1920" height="1080" data-parallax="off"
                                                class="rev-slidebg" data-no-retina>
                                            <!--
                                            <rs-layer id="slider-10-slide-47-layer-1" data-type="text"
                                                data-rsp_ch="on"
                                                data-xy="x:l,l,l,c;xo:55px,50px,55px,0;yo:447px,399px,364px,312px;"
                                                data-text="w:normal;s:20,18,18,16;l:25,24,28,24;fw:300;a:left,left,left,center;"
                                                data-frame_1="st:900;sp:1000;" data-frame_999="o:0;st:w;sR:8700;"
                                                style="z-index:9;">CRACTC will provide Career and Technical Educational (CTE) opportunities<br />
                                                to our member schools’ students, in the most economical fashion, where every student <br />
                                                has the same educational opportunity CRACTC Missionregardless of the size or location of the school.
                                            </rs-layer>
                                            -->
                                            <rs-layer id="slider-10-slide-47-layer-2" data-type="text"
                                                data-rsp_ch="on"
                                                data-xy="x:l,l,l,c;xo:48px,45px,50px,0;yo:226px,212px,179px,153px;"
                                                data-text="w:normal;s:115,100,95,78;l:115,89,90,71;ls:1px,0px,0px,0px;fw:700;a:left,left,left,center;"
                                                data-frame_1="st:300;sp:1000;sR:310;"
                                                data-frame_999="o:0;st:w;sR:7690;"
                                                style="z-index:11;text-transform:uppercase;">Our Mission
                                            </rs-layer>

                                            <rs-layer
                                            id="slider-10-slide-47-layer-3"
                                            data-type="text"
                                            data-rsp_ch="on"
                                            data-xy="x:l,l,l,c;xo:59px,50px,55px,0;yo:364px,321px,291px,245px;"
                                            data-text="w:normal;s:36,32,28,24;l:25,21,25,30;fw:600;a:left,left,left,center;"
                                            data-padding="t:15,15,11,7;r:20,20,15,15;b:15,15,11,7;l:20,20,15,15;"
                                            data-border="bos:solid;boc:#f2184f;bow:0,0px,0,6px;"
                                            data-frame_1="st:600;sp:1000;sR:500;"
                                            data-frame_999="o:0;st:w;sR:7500;"
                                            style="z-index:10;background-color:#202c45;"
                                            >CRACTC will provide Career and Technical Educational (CTE) opportunities<br /><br />
                                            to our member schools’ students, in the most economical fashion, where<br /><br />
                                            every student has the same educational opportunity CRACTC Mission<br /><br />
                                            regardless of the size or location of the school.
                                            </rs-layer>
                                            <!--
                                            <rs-layer
                                            id="slider-10-slide-47-layer-4"
                                            data-type="text"
                                            data-rsp_ch="on"
                                            data-xy="x:l,l,l,c;xo:55px,50px,55px,0;yo:539px,481px,448px,390px;"
                                            data-text="w:normal;s:18,14,18,20;l:25,19,18,22;a:left,left,left,center;"
                                            data-border="bos:solid;boc:#f2184f;bow:0,0,0,6px;"
                                            data-frame_1="st:1200;sp:1000;sR:1500;"
                                            data-frame_999="o:0;st:w;sR:6500;"
                                            style="z-index:8;"
                                            ><a href="#" class="btn btn-flat btn-theme-colored2 text-white">Get a Free Quote</a>
                                            </rs-layer>
                                            -->
                                        </rs-slide>
                                        <rs-slide data-key="rs-50" data-title="Our Students"
                                        data-thumb="frontend/images/front/carousel/ag.jpg"
                                        data-anim="ei:d;eo:d;s:d;r:0;t:slotslide-horizontal;sl:d;">
                                        <img src="frontend/images/front/carousel/gd.jpg" title="Our Students"
                                            width="1920" height="1165" data-parallax="off"
                                            class="rev-slidebg" data-no-retina>
                                        <!--
                                        <rs-layer id="slider-10-slide-50-layer-1" data-type="text"
                                            data-rsp_ch="on"
                                            data-xy="x:r,r,r,c;xo:55px,50px,55px,0;yo:447px,399px,364px,312px;"
                                            data-text="w:normal;s:20,18,18,16;l:25,24,28,24;fw:300;a:right,right,right,center;"
                                            data-frame_1="st:900;sp:1000;" data-frame_999="o:0;st:w;sR:8700;"
                                            style="z-index:9;"> CRACTC delivers CTE courses to students utilizing Interactive Television (ITV) and Online Virtual
                                            classroom environments
                                        </rs-layer>
                                        -->
                                        <rs-layer id="slider-10-slide-50-layer-2" data-type="text"
                                            data-rsp_ch="on"
                                            data-xy="x:r,r,r,c;xo:50px,45px,50px,0;yo:226px,212px,179px,153px;"
                                            data-text="w:normal;s:115,100,95,78;l:115,89,90,71;ls:1px,0px,0px,0px;fw:700;a:right,right,right,center;"
                                            data-frame_1="st:300;sp:1000;sR:310;"
                                            data-frame_999="o:0;st:w;sR:7690;"
                                            style="z-index:11;text-transform:uppercase;">Our Students
                                        </rs-layer>
                                        <rs-layer id="slider-10-slide-48-layer-3" data-type="text"
                                            data-rsp_ch="on"
                                            data-xy="x:r,r,r,c;xo:-100px,50px,55px,0;yo:354px,321px,291px,245px;"
                                            data-text="w:normal;s:36,32,28,24;l:25,21,25,30;fw:600;a:left,left,left,center;"
                                            data-padding="t:15,15,11,7;r:30,20,15,15;b:15,15,11,7;l:30,20,15,15;"
                                            data-border="bos:solid;boc:#f2184f;bow:0,6px,0,6px;bor:50px,50px,50px,50px;"
                                            data-frame_1="st:600;sp:1000;sR:500;"
                                            data-frame_999="o:0;st:w;sR:7500;"
                                            style="z-index:10;background-color:#202c45;">
                                            CRACTC delivers CTE courses to students utilizing Interactive<br /><br />
                                            Television (ITV) and Online Virtual classroom environments
                                        </rs-layer>
                                        <!--
                                        <rs-layer id="slider-10-slide-50-layer-4" data-type="text"
                                            data-rsp_ch="on"
                                            data-xy="x:r,r,r,c;xo:55px,50px,55px,0;yo:539px,481px,448px,390px;"
                                            data-text="w:normal;s:18,14,18,20;l:25,19,18,22;a:center;"
                                            data-border="bos:solid;boc:#f2184f;bow:0,6px,0,0px;"
                                            data-frame_1="st:1200;sp:1000;sR:1500;"
                                            data-frame_999="o:0;st:w;sR:6500;" style="z-index:8;"><a
                                                href="#"
                                                class="btn btn-flat btn-theme-colored2 text-white">Get a Free
                                                Quote</a>
                                        </rs-layer>
                                        -->
                                    </rs-slide>
                                        <rs-slide data-key="rs-49" data-title="Our Courses"
                                            data-thumb="frontend/images/front/carousel/ag.jpg"
                                            data-anim="ei:d;eo:d;s:d;r:0;t:slotslide-horizontal;sl:d;">
                                            <img src="frontend/images/front/carousel/av.jpg" title="Our Courses"
                                                width="1920" height="1165" data-parallax="off"
                                                class="rev-slidebg" data-no-retina>
                                            <!--
                                            <rs-layer id="slider-10-slide-49-layer-1" data-type="text"
                                                data-rsp_ch="on"
                                                data-xy="x:r,r,r,c;xo:55px,50px,55px,0;yo:447px,399px,364px,312px;"
                                                data-text="w:normal;s:20,18,18,16;l:25,24,28,24;fw:300;a:right,right,right,center;"
                                                data-frame_1="st:900;sp:1000;" data-frame_999="o:0;st:w;sR:8700;"
                                                style="z-index:9;">We provides always our best services for our clients
                                                and always <br>try to achieve our client's trust and satisfaction.
                                            </rs-layer>
                                            -->
                                            <rs-layer id="slider-10-slide-49-layer-2" data-type="text"
                                                data-rsp_ch="on"
                                                data-xy="x:r,r,r,c;xo:50px,45px,50px,0;yo:226px,212px,179px,153px;"
                                                data-text="w:normal;s:115,100,95,78;l:115,89,90,71;ls:1px,0px,0px,0px;fw:700;a:right,right,right,center;"
                                                data-frame_1="st:300;sp:1000;sR:310;"
                                                data-frame_999="o:0;st:w;sR:7690;"
                                                style="z-index:11;text-transform:uppercase;">Our Courses
                                            <rs-layer id="slider-10-slide-49-layer-3" data-type="text"
                                                data-rsp_ch="on"
                                                data-xy="x:r,r,r,c;xo:755px,50px,55px,0;yo:134px,321px,291px,245px;"
                                                data-text="w:normal;s:36,32,28,24;l:25,21,25,30;fw:600;a:left,left,left,center;"
                                                data-padding="t:15,15,11,7;r:20,20,15,15;b:15,15,11,7;l:20,20,15,15;"
                                                data-border="bos:solid;boc:#f2184f;bow:0,6px,0,0px;"
                                                data-frame_1="st:600;sp:1000;sR:500;"
                                                data-frame_999="o:0;st:w;sR:7500;"
                                                style="z-index:10;background-color:#202c45;text-transform:uppercase;">CRACTC CTE courses will include hands-on<br /><br />
                                                and career exploration events
                                            </rs-layer>
                                            <!--
                                            <rs-layer id="slider-10-slide-49-layer-4" data-type="text"
                                                data-rsp_ch="on"
                                                data-xy="x:r,r,r,c;xo:55px,50px,55px,0;yo:539px,481px,448px,390px;"
                                                data-text="w:normal;s:18,14,18,20;l:25,19,18,22;a:center;"
                                                data-border="bos:solid;boc:#f2184f;bow:0,6px,0,0px;"
                                                data-frame_1="st:1200;sp:1000;sR:1500;"
                                                data-frame_999="o:0;st:w;sR:6500;" style="z-index:8;"><a
                                                    href="#"
                                                    class="btn btn-flat btn-theme-colored2 text-white">Get a Free
                                                    Quote</a>
                                            </rs-layer>
                                            -->
                                        </rs-slide>
                                    </rs-slides>
                                    <rs-static-layers>
                                    </rs-static-layers>
                                    <rs-progress class="rs-bottom"
                                        style="height: 5px; background: rgba(199,199,199,0.5);"></rs-progress>
                                </rs-module>
                                <script type="text/javascript">
                                    if (typeof revslider_showDoubleJqueryError === "undefined") {
                                        function revslider_showDoubleJqueryError(sliderID) {
                                            var err = "<div class='rs_error_message_box'>";
                                            err += "<div class='rs_error_message_oops'>Oops...</div>";
                                            err += "<div class='rs_error_message_content'>";
                                            err +=
                                                "You have some jquery.js library include that comes after the Slider Revolution files js inclusion.<br>";
                                            err +=
                                                "To fix this, you can:<br>&nbsp;&nbsp;&nbsp; 1. Set 'Module General Options' -> 'Advanced' -> 'jQuery & OutPut Filters' -> 'Put JS to Body' to on";
                                            err += "<br>&nbsp;&nbsp;&nbsp; 2. Find the double jQuery.js inclusion and remove it";
                                            err += "</div>";
                                            err += "</div>";
                                            jQuery(sliderID).show().html(err);
                                        }
                                    }
                                </script>
                            </rs-module-wrap>
                            <!-- END REVOLUTION SLIDER -->
                        </div>
                    </div>
                </div>
            </section>

            <!-- Section: Welcome -->
            <section id="welcome">
                <div class="container">
                    <div class="section-content">
                        <div class="row">
                            <div class="col-md-12 col-lg-6 col-xl-6">
                                <h2 class="text-uppercase mt-0 line-bottom line-bottom-theme-colored1">Welcome!</h2>
                                <p>Welcome to the Central Regional Area Career and Technical Center (CRACTC)! The CRACTC
                                    is a “Virtua” Career and Technical Center established in 2008 as a partnership with
                                    the CREA – Central Regional Education Association. The CREA is 1 of 7 Rural
                                    Educational Associations (REA’s) in North Dakota. Initial funding for this program
                                    came from a grant from the North Dakota Legislature through the State Department of
                                    Career and Technical Education and from the memberships of 28 school districts with
                                    high schools that are members of the CREA; school districts who are not part of the
                                    CREA/CRACTC membership may also enroll in CRACTC courses (dependent upon
                                    availability) at a non-member rate.</p>
                                <p> CRACTC offers more than 30 online and ITV (interactive television) courses in 9
                                    career areas.</p>
                                <p>CRACTC Mission:To provide Career and Technical Educational (CTE) opportunities to our
                                    member schools’ students, in the most economical fashion, where every student has
                                    the same educational opportunity regardless of the size or location of the school.
                                </p>
                                <a href="https://cractc.org/wp-content/uploads/2023/03/cractc-presentation.pptx"
                                    class="btn btn-sm btn-theme-colored2 text-white mb-md-40">Expanding CTE Programming
                                    for Rural Schools (PowerPoint)</a>
                            </div>
                            <div class="col-md-12 col-lg-6 col-xl-6">
                                <div class="box-hover-effect tm-sc-video-popup tm-sc-video-popup-button-over-image">
                                    <div class="effect-wrapper">
                                        <div class="thumb">
                                            <img class="w-100" src="frontend/images/front/e-learning.jpg"
                                                alt="">
                                        </div>
                                        <div class="animated-css-play-button"><span class="play-icon"><i
                                                    class="fa fa-play"></i></span></div>
                                        <a class="hover-link" data-lightbox-gallery="youtube-video"
                                            href="https://www.youtube.com/watch?v=xcJtL7QggTI" title=""></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Section: Courses -->
            <section id="courses" class="bg-silver-light">
                <div class="container">
                    <div class="section-title">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-60">
                                    <div class="tm-sc tm-sc-section-title section-title">
                                        <div class="title-wrapper">
                                            <h2 class="text-uppercase line-bottom line-bottom-theme-colored1">Our <span
                                                    class="text-theme-colored1">Courses</span></h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="section-content">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="owl-carousel tm-owl-carousel-4col" data-dots="true">
                                    <div class="course-item mb-30 bg-white border-1px">
                                        <div class="course-thumb"> <img alt="featured project"
                                                src="frontend/images/courses/ag.png" class="w-100"></div>
                                        <div class="content text-left flip p-25 pt-0">
                                            <h4 class="line-bottom line-bottom-theme-colored1 mb-30 pb-0">Agriculture
                                            </h4>
                                            <p>3 classes to choose from!</p>
                                            <a class="btn btn-dark btn-theme-colored2 btn-xs text-uppercase mt-10"
                                                href="frontend/pdf/registration-book/ag.pdf">View Course Catalog</a>
                                        </div>
                                    </div>
                                    <div class="course-item mb-30 bg-white border-1px">
                                        <div class="course-thumb"> <img alt="featured project"
                                                src="frontend/images/courses/av.png" class="w-100"></div>
                                        <div class="content text-left flip p-25 pt-0">
                                            <h4 class="line-bottom line-bottom-theme-colored1 mb-30 pb-0">Aviation
                                            </h4>
                                            <p>3 classes to choose from!</p>
                                            <a class="btn btn-dark btn-theme-colored2 btn-xs text-uppercase mt-10"
                                                href="frontend/pdf/registration-book/av.pdf">View Course Catalog</a>
                                        </div>
                                    </div>
                                    <div class="course-item mb-30 bg-white border-1px">
                                        <div class="course-thumb"> <img alt="featured project"
                                                src="frontend/images/courses/facs.png" class="w-100"></div>
                                        <div class="content text-left flip p-25 pt-0">
                                            <h4 class="line-bottom line-bottom-theme-colored1 mb-30 pb-0">FACS
                                            </h4>
                                            <p>7 classes to choose from!</p>
                                            <a class="btn btn-dark btn-theme-colored2 btn-xs text-uppercase mt-10"
                                                href="frontend/pdf/registration-book/facs.pdf">View Course Catalog</a>
                                        </div>
                                    </div>
                                    <div class="course-item mb-30 bg-white border-1px">
                                        <div class="course-thumb"> <img alt="featured project"
                                                src="frontend/images/courses/gd.png" class="w-100"></div>
                                        <div class="content text-left flip p-25 pt-0">
                                            <h4 class="line-bottom line-bottom-theme-colored1 mb-30 pb-0">Graphic Design
                                            </h4>
                                            <p>2 classes to choose from!</p>
                                            <a class="btn btn-dark btn-theme-colored2 btn-xs text-uppercase mt-10"
                                                href="frontend/pdf/registration-book/gd.pdf">View Course Catalog</a>
                                        </div>
                                    </div>
                                    <div class="course-item mb-30 bg-white border-1px">
                                        <div class="course-thumb"> <img alt="featured project"
                                                src="frontend/images/courses/it.png" class="w-100"></div>
                                        <div class="content text-left flip p-25 pt-0">
                                            <h4 class="line-bottom line-bottom-theme-colored1 mb-30 pb-0">Information Technology
                                            </h4>
                                            <p>9 classes to choose from!</p>
                                            <a class="btn btn-dark btn-theme-colored2 btn-xs text-uppercase mt-10"
                                                href="frontend/pdf/registration-book/it.pdf">View Course Catalog</a>
                                        </div>
                                    </div>
                                    <div class="course-item mb-30 bg-white border-1px">
                                        <div class="course-thumb"> <img alt="featured project"
                                                src="frontend/images/courses/ma.png" class="w-100"></div>
                                        <div class="content text-left flip p-25 pt-0">
                                            <h4 class="line-bottom line-bottom-theme-colored1 mb-30 pb-0">Marketing
                                            </h4>
                                            <p>5 classes to choose from!</p>
                                            <a class="btn btn-dark btn-theme-colored2 btn-xs text-uppercase mt-10"
                                                href="frontend/pdf/registration-book/ma.pdf">View Course Catalog</a>
                                        </div>
                                    </div>
                                    <div class="course-item mb-30 bg-white border-1px">
                                        <div class="course-thumb"> <img alt="featured project"
                                                src="frontend/images/courses/mc.png" class="w-100"></div>
                                        <div class="content text-left flip p-25 pt-0">
                                            <h4 class="line-bottom line-bottom-theme-colored1 mb-30 pb-0">Medical Careers
                                            </h4>
                                            <p>4 classes to choose from!</p>
                                            <a class="btn btn-dark btn-theme-colored2 btn-xs text-uppercase mt-10"
                                                href="frontend/pdf/registration-book/mc.pdf">View Course Catalog</a>
                                        </div>
                                    </div>
                                    <div class="course-item mb-30 bg-white border-1px">
                                        <div class="course-thumb"> <img alt="featured project"
                                                src="frontend/images/courses/stem.png" class="w-100"></div>
                                        <div class="content text-left flip p-25 pt-0">
                                            <h4 class="line-bottom line-bottom-theme-colored1 mb-30 pb-0">STEM
                                            </h4>
                                            <p>4 classes to choose from!</p>
                                            <a class="btn btn-dark btn-theme-colored2 btn-xs text-uppercase mt-10"
                                                href="frontend/pdf/registration-book/stem.pdf">View Course Catalog</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a href="https://cractc.org/wp-content/uploads/2023/02/Western-Dakota-2023-24-Registration-Form-2.xlsx"
                        class="btn btn-sm btn-theme-colored2 text-white mb-md-40">Registration Spreadsheet</a>
                    </div>
                </div>
            </section>

            <!-- Section: Admin Info -->
            <section id="adminInfo">
                <div class="container">
                    <div class="section-title">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-60">
                                    <div class="tm-sc tm-sc-section-title section-title">
                                        <div class="title-wrapper">
                                            <h2 class="text-uppercase line-bottom line-bottom-theme-colored1">Admin <span
                                                    class="text-theme-colored1">Info</span></h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="section-content">
                        <div class="row">
                            <div class="col-md-12 col-lg-6 col-xl-6">
                                <p>For a list of available courses, click the registration guide below of click the Courses tab at the top of the screen.
                                    If you are ready to register your students, please click on the registration form, save it to your computer,
                                    and email it to cractc.online@k12.nd.us once you have filled it out.</p>
                                <p>If you have questions, please feel free to contact Lyle Krueger at 701-415-0453 or Amy Johnson at 701-641-0569.</p>
                                <p> CRACTC offers more than 30 online and ITV (interactive television) courses in 9
                                    career areas.</p>
                                <p>CRACTC Mission:To provide Career and Technical Educational (CTE) opportunities to our
                                    member schools’ students, in the most economical fashion, where every student has
                                    the same educational opportunity regardless of the size or location of the school.
                                </p>
                                <ul>
                                    <li><a href="https://cractc.org/wp-content/uploads/2023/02/2023-2024-Course-Catalog-5.pdf" target="_blank">Registration Book</a></li>
                                    <li><a href="https://cractc.org/wp-content/uploads/2023/04/western-dakota-2023-24-registration-form.xlsx" target="_blank">Registration Form</a></li>
                                    <li><a href="https://cractc.org/wp-content/uploads/2023/02/CRACTC-Calendar-2023_24.pdf" target="_blank">2023/2024 Calendar</a></li>
                                    <li><a href="https://cractc.org/wp-content/uploads/2021/02/CRACTC-Welding-Claim-Reimbursement-form.docx" target="_blank">Welding Claim Reimbursement Form</a></li>
                                    <li><a href="https://cractc.org/wp-content/uploads/2021/02/CRACTC-Facilitator-Claim-Reimbursement-form.docx" target="_blank">Claim Reimbursement Form</a></li>
                                    <li><a href="https://cractc.org/wp-content/uploads/2021/02/CRACTC-Reimbursement-Claim-Instructions.pdf" target="_blank">Reimbursement Procedures</a></li>
                                    <li><a href="https://cractc.org/wp-content/uploads/2023/09/CRACTC-Travel-Reimbursement-Form-2023.doc" target="_blank">CRACTC Travel Reimbursement Form 2023</a></li>
                                    <li><a href="https://cractc.org/wp-content/uploads/2021/02/CRACTC-Online-CTE-Course-Dual-Credit-Offerings-20-21SY.docx" target="_blank">Online CTE Course Dual Credit Offerings</a></li>
                                    <li><a href="https://cractc.org/wp-content/uploads/2023/01/cractc-handbook-2022-2023sy.pdf" target="_blank">Program Handbook</a></li>
                                </ul>
                                <h4>Plans of Study for State Scholarship</h4>
                                <p>ND resident students may apply for either the Career & Technical Education (CTE) or Academic Scholarships.
                                    Students utilizing CTE courses to meet the necessary requirements need to have two units of CTE credits
                                    from a coordinated plan of study recommended by the ND Department of Career & Technical Education and approved by the
                                    ND Superintendent of Public Instruction.</p>
                                <p>CRACTC has created the plan of study document below with regard to the courses we provide to help guide you through this process.
                                    If you have any questions regarding the document or course offerings, please contact Assistant Director Lyle Krueger at your convenience.</p>
                                <a href="https://06940599-14f0-49b1-a0f2-586ae70eb6aa.filesusr.com/ugd/156122_73917374bd334f6bb75d42e051c1d417.xlsx?dn=Career%20Clusters%20and%20Program%20Pathways%20for"
                                    class="btn btn-sm btn-theme-colored2 text-white mb-md-40">View the Plans of Study</a>
                            </div>
                            <div class="col-md-12 col-lg-6 col-xl-6">
                                <div class="box-hover-effect tm-sc-video-popup tm-sc-video-popup-button-over-image">
                                    <div class="effect-wrapper">
                                        <div class="thumb">
                                            <img class="w-100" src="frontend/images/front/robot.jpg"
                                                alt="">
                                        </div>
                                    </div>
                                </div>
                                <div class="box-hover-effect tm-sc-video-popup tm-sc-video-popup-button-over-image mt-5">
                                    <div class="effect-wrapper">
                                        <div class="thumb">
                                            <img class="w-100" src="frontend/images/front/blood-pressure.jpg"
                                                alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Section: Admin Info -->
            <section id="studentCorner">
                <div class="container">
                    <div class="section-title">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-60">
                                    <div class="tm-sc tm-sc-section-title section-title">
                                        <div class="title-wrapper">
                                            <h2 class="text-uppercase line-bottom line-bottom-theme-colored1">Student <span
                                                    class="text-theme-colored1">Corner</span></h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="section-content">
                        <div class="row">
                            <div class="col-md-6 col-lg-6 col-xl-3">
                                <a href="http://westernndctc.ps.state.nd.us/public">
                                <div class="tm-widget-contact-info contact-info-style1 contact-icon-theme-colored1">
                                    <div class="thumb">
                                        <img alt="Logo" src="frontend/images/front/powerschool.png">
                                    </div>
                                    <div class="description">
                                        <h4 style="color:#ffffff">PowerSchool</h4>
                                        <p>Click here to view your individual assignment and overall grades.</p>
                                    </div>
                                </div>
                                </a>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-3">
                                <a href="https://moodle.cractc.org">
                                <div class="tm-widget-contact-info contact-info-style1 contact-icon-theme-colored1">
                                    <div class="thumb">
                                        <img alt="Logo" src="frontend/images/front/moodle.png">
                                    </div>
                                    <div class="description">
                                        <h4 style="color:#ffffff">Moodle</h4>
                                        <p>Click here if your instructor uses Moodle to send out class materials and assignments.</p>
                                    </div>
                                </div>
                                </a>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-3">
                                <a href="https://classroom.google.com/">
                                <div class="tm-widget-contact-info contact-info-style1 contact-icon-theme-colored1">
                                    <div class="thumb">
                                        <img alt="Logo" src="frontend/images/front/classroom.png">
                                    </div>
                                    <div class="description">
                                        <h4 style="color:#ffffff">Google Classroom</h4>
                                        <p>Click here if your instructor uses Google Classroom to send out class materials and assignments..</p>
                                    </div>
                                </div>
                                </a>
                            </div>
                            <div class="col-md-12 col-lg-6 col-xl-6">
                                <h2>Scholarship Corner</h2>
                                <p>CTE concentrators (students that complete 2 or more credits in a program of study) can qualify for the $6000 ND State CTE Scholarship Program. See your high school counselor for details- which may include taking the “Work Keys” test to qualify.</p>
                                <ul>
                                    <li><a href="https://cractc.org/wp-content/uploads/2023/02/BCCF-Donna-Johnson-Memorial-Scholarship-2023.pdf" target="_blank">Bismarck Cancer Center Foundation-Donna Johnson Memorial Scholarship</a></li>
                                    <li><a href="http://ndcel.us/page/scholarships" target="_blank">NDCEL Scholarships</a> (Youth Scholarship Award, Dr. Larry A. Klundt Educational Leader Award, Jerry Bartholomay Scholarship for Aspiring Administrators, ESAND Educational Scholarship)</li>
                                    <li><a href="http://tcscholarships.com/" target="_blank">TC Energy Scholarship</a> TC Energy is looking for scholarship applicants in three catagories:  STEM, Energy Trades, and Indigenous Legacy.  The 2022 Scholarship program showed there were 3,400+ applications and an award of $2.1 M dollars to 806 deserving students across North America.</li>
                                    <li><a href="https://thescholarshipsystem.com/blog-for-students-families/the-ultimate-list-of-scholarships-for-women-and-girls/" target="_blank">The Ultimate List of Scholarships for Women and Girls</a></li>
                                </ul>
                            </div>

                            <div class="col-md-12 col-lg-6 col-xl-6">
                                <div class="box-hover-effect tm-sc-video-popup tm-sc-video-popup-button-over-image">
                                    <div class="effect-wrapper">
                                        <div class="thumb">
                                            <img class="w-100" src="frontend/images/front/student.jpg"
                                                alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12 col-xl-12">
                                <h2>Grade Scale</h2>
                                <p>Semester Grades are composed of the course content grade and a semester evaluation (in applicable courses).  If a semester evaluation does not occur, the semester grade will be on the semester course content grades only.</p>
                                <ul>
                                    <li>A: 100-92</li>
                                    <li>B: 91-83</li>
                                    <li>C: 82-74</li>
                                    <li>D: 73-65</li>
                                </u>
                                <p>Sem Content Grade: 90%<br />
                                    Semester Evaluation: 10%</p>
                                <p>Dual credit courses offered through BSC will use the BSC grade scale (90-80-70-60) for ALL enrolled students as the content is considered college-level coursework (this includes students NOT registered to take the course for dual credit).</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Section: Our Team -->
            <section id="ourTeam" class="bg-silver-light">
                <div class="container">
                    <div class="section-title">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-60">
                                    <div class="tm-sc tm-sc-section-title section-title">
                                        <div class="title-wrapper">
                                            <h2 class="text-uppercase line-bottom line-bottom-theme-colored1">Our <span
                                                    class="text-theme-colored1">Team</span></h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="section-content">
                        <div class="row">
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-3">
                                <div class="staff-item mb-lg-40">
                                    <div class="staff-thumb"> <img alt="img"
                                            src="frontend/images/team/hoerauf.png" class="w-100"></div>
                                    <div class="staff-content">
                                        <h4 class="staff-name text-theme-colored1 mt-0">Dale Hoerauf - <small>Executive
                                                Director</small></h4>
                                        <p class="mb-20">Dale.Hoerauf@k12.nd.us</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-3">
                                <div class="staff-item mb-lg-40">
                                    <div class="staff-thumb"> <img alt="img"
                                            src="frontend/images/team/krueger.png" class="w-100"></div>
                                    <div class="staff-content">
                                        <h4 class="staff-name text-theme-colored1 mt-0">Lyle Krueger - <small>Assitant
                                                Director</small></h4>
                                        <p class="mb-20">Lyle.Krueger@k12.nd.us</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-3">
                                <div class="staff-item mb-lg-40">
                                    <div class="staff-thumb"> <img alt="img"
                                            src="frontend/images/team/hoerauf.png" class="w-100"></div>
                                    <div class="staff-content">
                                        <h4 class="staff-name text-theme-colored1 mt-0">Amy Johnson - <small>Office
                                                Assistant</small></h4>
                                        <p class="mb-20">amy.a.johnson@k12.nd.us</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Gallery Grid 3 -->
            <section id="gallery">
                <div class="container">
                    <div class="section-title">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-60">
                                    <div class="tm-sc tm-sc-section-title section-title">
                                        <div class="title-wrapper">
                                            <h2 class="text-uppercase line-bottom line-bottom-theme-colored1">Our <span
                                                    class="text-theme-colored1">Gallery</span></h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="section-content">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="tm-sc-gallery tm-sc-gallery-grid gallery-style1-current-theme">
                                    <!-- Isotope Filter -->
                                    <div class="isotope-layout-filter filter-style-4 cat-filter-default"
                                        data-link-with="gallery-holder-618422">
                                        <a href="#" class="active" data-filter="*">All</a>
                                        <a href="#" class="" data-filter=".photos">Photos</a>
                                        <a href="#" class="" data-filter=".campus">Campus</a>
                                        <a href="#" class="" data-filter=".student">Student</a>
                                    </div>
                                    <!-- End Isotope Filter -->

                                    <!-- Isotope Gallery Grid -->
                                    <div id="gallery-holder-618422"
                                        class="isotope-layout grid-4 gutter-5 clearfix lightgallery-lightbox">
                                        <div class="isotope-layout-inner">
                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item photos">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/1.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/1.jpg"
                                                                                    data-src="frontend/images/gallery/1.jpg"
                                                                                    title="Gallery 1"
                                                                                    href="images/gallery/1.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 1"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 1</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item campus student">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/2.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/2.jpg"
                                                                                    data-src="frontend/images/gallery/2.jpg"
                                                                                    title="Gallery 2"
                                                                                    href="images/gallery/2.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 2"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 2</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item photos student">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/3.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/3.jpg"
                                                                                    data-src="frontend/images/gallery/3.jpg"
                                                                                    title="Gallery 3"
                                                                                    href="images/gallery/3.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 3"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 3</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item campus">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/2.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/2.jpg"
                                                                                    data-src="frontend/images/gallery/2.jpg"
                                                                                    title="Gallery 2"
                                                                                    href="images/gallery/2.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 2"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 2</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item campus student">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/2.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/2.jpg"
                                                                                    data-src="frontend/images/gallery/2.jpg"
                                                                                    title="Gallery 2"
                                                                                    href="images/gallery/2.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 2"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 2</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item photos student">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/3.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/3.jpg"
                                                                                    data-src="frontend/images/gallery/3.jpg"
                                                                                    title="Gallery 3"
                                                                                    href="images/gallery/3.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 3"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 3</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item campus">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/2.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/2.jpg"
                                                                                    data-src="frontend/images/gallery/2.jpg"
                                                                                    title="Gallery 2"
                                                                                    href="images/gallery/2.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 2"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 2</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item campus student">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/2.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/2.jpg"
                                                                                    data-src="frontend/images/gallery/2.jpg"
                                                                                    title="Gallery 2"
                                                                                    href="images/gallery/2.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 2"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 2</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item photos student">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/3.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/3.jpg"
                                                                                    data-src="frontend/images/gallery/3.jpg"
                                                                                    title="Gallery 3"
                                                                                    href="images/gallery/3.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 3"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 3</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item photos">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/1.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/1.jpg"
                                                                                    data-src="frontend/images/gallery/1.jpg"
                                                                                    title="Gallery 1"
                                                                                    href="images/gallery/1.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 1"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 1</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item campus student">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/2.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/2.jpg"
                                                                                    data-src="frontend/images/gallery/2.jpg"
                                                                                    title="Gallery 2"
                                                                                    href="images/gallery/2.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 2"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 2</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->

                                            <!-- Isotope Item Start -->
                                            <div class="isotope-item photos student">
                                                <div class="isotope-item-inner">
                                                    <div class="tm-gallery">
                                                        <div class="tm-gallery-inner">
                                                            <div class="thumb">
                                                                <a href="#">
                                                                    <img width="672" height="448"
                                                                        src="frontend/images/gallery/3.jpg"
                                                                        class="" alt="" />
                                                                </a>
                                                            </div>
                                                            <div class="tm-gallery-content-wrapper">
                                                                <div class="tm-gallery-content">
                                                                    <div class="tm-gallery-content-inner">
                                                                        <div class="icons-holder-inner">
                                                                            <div
                                                                                class="styled-icons icon-dark icon-circled icon-theme-colored1">
                                                                                <a class="lightgallery-trigger styled-icons-item"
                                                                                    data-exthumbimage="images/gallery/3.jpg"
                                                                                    data-src="frontend/images/gallery/3.jpg"
                                                                                    title="Gallery 3"
                                                                                    href="images/gallery/3.jpg"><i
                                                                                        class="fa fa-plus"></i></a>
                                                                                <a class="styled-icons-item"
                                                                                    title="Gallery 3"
                                                                                    href="#"><i
                                                                                        class="fa fa-link"></i></a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="title-holder">
                                                                            <h5 class="title"><a
                                                                                    href="#">Gallery 3</a></h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Isotope Item End -->
                                        </div>
                                    </div>
                                    <!-- End Isotope Gallery Grid -->
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Section: Upcoming Event -->
            <section>
                <div class="container">
                    <div class="section-content">
                        <div class="row">
                            <div class="col-sm-12 col-md-12 col-lg-6">
                                <h2 class="line-bottom line-bottom-theme-colored1">Upcoming <span
                                        class="text-theme-colored1">Events</span></h2>
                                <div class="upcoming-events-current-style mb-10 mb-sm-40">
                                    <div class="row align-items-center">
                                        <div class="col-sm-3 pr-0 pr-sm-15">
                                            <div class="thumb">
                                                <img class="w-100" src="frontend/images/event/1.jpg" alt="...">
                                            </div>
                                        </div>
                                        <div class="col-sm-8">
                                            <div class="event-details p-15 pt-0 pb-0">
                                                <h5 class="media-heading text-uppercase mt-0 mb-0 mt-sm-15">Upcoming
                                                    Event Title</h5>
                                                <ul class="event-location mb-10">
                                                    <li class="event-time"><i
                                                            class="far fa-clock text-theme-colored2 font-icon sm-display-block"></i>
                                                        04:00 am</li>
                                                    <li class="event-address"><i
                                                            class="fas fa-map-marker-alt text-theme-colored2 font-icon sm-display-block"></i>
                                                        Broklyn Street 40, New York</li>
                                                </ul>
                                                <p class="mb-10">Dignissim cras tincidunt lorem ipsum is simply free
                                                    text feugiat at augue. Id purus integer orci.</p>
                                                <a class="text-theme-colored2" href="#">Read More →</a>
                                            </div>
                                        </div>
                                        <div class="col"></div>
                                    </div>
                                </div>
                                <div class="upcoming-events-current-style mb-10 mb-sm-40">
                                    <div class="row align-items-center">
                                        <div class="col-sm-3 pr-0 pr-sm-15">
                                            <div class="thumb">
                                                <img class="w-100" src="frontend/images/event/2.jpg" alt="...">
                                            </div>
                                        </div>
                                        <div class="col-sm-8">
                                            <div class="event-details p-15 pt-0 pb-0">
                                                <h5 class="media-heading text-uppercase mt-0 mb-0 mt-sm-15">Upcoming
                                                    Event Title</h5>
                                                <ul class="event-location mb-10">
                                                    <li class="event-time"><i
                                                            class="far fa-clock text-theme-colored2 font-icon sm-display-block"></i>
                                                        04:00 am</li>
                                                    <li class="event-address"><i
                                                            class="fas fa-map-marker-alt text-theme-colored2 font-icon sm-display-block"></i>
                                                        Broklyn Street 40, New York</li>
                                                </ul>
                                                <p class="mb-10">Dignissim cras tincidunt lorem ipsum is simply free
                                                    text feugiat at augue. Id purus integer orci.</p>
                                                <a class="text-theme-colored2" href="#">Read More →</a>
                                            </div>
                                        </div>
                                        <div class="col"></div>
                                    </div>
                                </div>
                                <div class="upcoming-events-current-style mb-10 mb-md-40">
                                    <div class="row align-items-center">
                                        <div class="col-sm-3 pr-0 pr-sm-15">
                                            <div class="thumb">
                                                <img class="w-100" src="frontend/images/event/3.jpg" alt="...">
                                            </div>
                                        </div>
                                        <div class="col-sm-8">
                                            <div class="event-details p-15 pt-0 pb-0">
                                                <h5 class="media-heading text-uppercase mt-0 mb-0 mt-sm-15">Upcoming
                                                    Event Title</h5>
                                                <ul class="event-location mb-10">
                                                    <li class="event-time"><i
                                                            class="far fa-clock text-theme-colored2 font-icon sm-display-block"></i>
                                                        04:00 am</li>
                                                    <li class="event-address"><i
                                                            class="fas fa-map-marker-alt text-theme-colored2 font-icon sm-display-block"></i>
                                                        Broklyn Street 40, New York</li>
                                                </ul>
                                                <p class="mb-10">Dignissim cras tincidunt lorem ipsum is simply free
                                                    text feugiat at augue. Id purus integer orci.</p>
                                                <a class="text-theme-colored2" href="#">Read More →</a>
                                            </div>
                                        </div>
                                        <div class="col"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-12 col-lg-6">
                                <h2 class="line-bottom line-bottom-theme-colored1">Why <span
                                        class="text-theme-colored1">Choose Us?</span></h2>
                                <p>The Cweren Law Firm is a recognized leader in landlord tenant representation
                                    throughout Texas.The largest professional property.</p>
                                <div class="accordion tm-accordion accordion-classic accordion-theme-colored1"
                                    id="accordion500">
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="heading501">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapse501" aria-expanded="true"
                                                aria-controls="collapse501">
                                                <strong>Where do I find my Office product key?</strong>
                                            </button>
                                        </h2>
                                        <div id="collapse501" class="accordion-collapse collapse show"
                                            aria-labelledby="heading501" data-bs-parent="#accordion500">
                                            <div class="accordion-body">
                                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus
                                                terry richardson ad squid. 3 wolf moon officia aute, non cupidatat
                                                skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.
                                                Brunch 3 wolf moon tempor
                                            </div>
                                        </div>
                                    </div>
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="heading502">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#collapse502"
                                                aria-expanded="false" aria-controls="collapse502">
                                                <strong>I am having trouble, what else should I do?</strong>
                                            </button>
                                        </h2>
                                        <div id="collapse502" class="accordion-collapse collapse"
                                            aria-labelledby="heading502" data-bs-parent="#accordion500">
                                            <div class="accordion-body">
                                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus
                                                terry richardson ad squid. 3 wolf moon officia aute, non cupidatat
                                                skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.
                                                Brunch 3 wolf moon tempor
                                            </div>
                                        </div>
                                    </div>
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="heading503">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#collapse503"
                                                aria-expanded="false" aria-controls="collapse503">
                                                <strong>I need more information about Theme.</strong>
                                            </button>
                                        </h2>
                                        <div id="collapse503" class="accordion-collapse collapse"
                                            aria-labelledby="heading503" data-bs-parent="#accordion500">
                                            <div class="accordion-body">
                                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus
                                                terry richardson ad squid. 3 wolf moon officia aute, non cupidatat
                                                skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.
                                                Brunch 3 wolf moon tempor
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Section: Testimonial -->
            <section class="layer-overlay overlay-theme-colored2-9 bg-no-repeat bg-pos-center-center"
                data-tm-bg-img="frontend/images/bg/bg2.jpg">
                <div class="container pt-90 pb-90">
                    <div class="section-title">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-60">
                                    <div class="tm-sc tm-sc-section-title section-title">
                                        <div class="title-wrapper">
                                            <h6 class="m-0 text-gray-lightgray">Happy Student</h6>
                                            <h2
                                                class="mt-0 mb-0 text-uppercase line-bottom line-bottom-theme-colored1 text-white">
                                                Testimonials<span class="text-theme-colored2">.</span></h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="section-content">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="owl-carousel tm-owl-carousel-2col" data-dots="true">
                                    <div class="testimonial pt-10">
                                        <div class="thumb float-start mt-10 mb-0 mr-0 pr-20">
                                            <img width="75" class="rounded-circle" alt=""
                                                src="frontend/images/testimonials/1.jpg">
                                        </div>
                                        <div class="ml-100 overflow-hidden">
                                            <h5 class="text-white mt-0">Lorem ipsum dolor sit amet, consectetur
                                                adipisicing elit. Quas vel sint, ut. Quisquam doloremque minus possimus
                                                eligendi dolore ad.</h5>
                                            <p class="author mt-20">- <span
                                                    class="font-weight-500 text-theme-colored1">Catherine Grace,</span>
                                                <small><em class="text-gray-lightgray">CEO apple.inc</em></small></p>
                                        </div>
                                    </div>
                                    <div class="testimonial pt-10">
                                        <div class="thumb float-start mt-10 mb-0 mr-0 pr-20">
                                            <img width="75" class="rounded-circle" alt=""
                                                src="frontend/images/testimonials/1.jpg">
                                        </div>
                                        <div class="ml-100 overflow-hidden">
                                            <h5 class="text-white mt-0">Lorem ipsum dolor sit amet, consectetur
                                                adipisicing elit. Quas vel sint, ut. Quisquam doloremque minus possimus
                                                eligendi dolore ad.</h5>
                                            <p class="author mt-20">- <span
                                                    class="font-weight-500 text-theme-colored1">Catherine
                                                    Grace,</span> <small><em class="text-gray-lightgray">CEO
                                                        apple.inc</em></small></p>
                                        </div>
                                    </div>
                                    <div class="testimonial pt-10">
                                        <div class="thumb float-start mt-10 mb-0 mr-0 pr-20">
                                            <img width="75" class="rounded-circle" alt=""
                                                src="frontend/images/testimonials/1.jpg">
                                        </div>
                                        <div class="ml-100 overflow-hidden">
                                            <h5 class="text-white mt-0">Lorem ipsum dolor sit amet, consectetur
                                                adipisicing elit. Quas vel sint, ut. Quisquam doloremque minus possimus
                                                eligendi dolore ad.</h5>
                                            <p class="author mt-20">- <span
                                                    class="font-weight-500 text-theme-colored1">Catherine
                                                    Grace,</span> <small><em class="text-gray-lightgray">CEO
                                                        apple.inc</em></small></p>
                                        </div>
                                    </div>
                                    <div class="testimonial pt-10">
                                        <div class="thumb float-start mt-10 mb-0 mr-0 pr-20">
                                            <img width="75" class="rounded-circle" alt=""
                                                src="frontend/images/testimonials/1.jpg">
                                        </div>
                                        <div class="ml-100 overflow-hidden">
                                            <h5 class="text-white mt-0">Lorem ipsum dolor sit amet, consectetur
                                                adipisicing elit. Quas vel sint, ut. Quisquam doloremque minus possimus
                                                eligendi dolore ad.</h5>
                                            <p class="author mt-20">- <span
                                                    class="font-weight-500 text-theme-colored1">Catherine
                                                    Grace,</span> <small><em class="text-gray-lightgray">CEO
                                                        apple.inc</em></small></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Section: Contact -->
            <section id="contact">
                <div class="container">
                    <div class="section-title mb-10">
                        <div class="row">
                            <div class="col-md-12">
                                <h2
                                    class="text-uppercase text-theme-colored1 title line-bottom line-bottom-theme-colored1 line-height-1 mt-0">
                                    Contact <span class="text-theme-colored2 font-weight-400">Us</span></h2>
                            </div>
                        </div>
                    </div>
                    <div class="section-content">
                        <div class="row">
                            <div class="col-md-5">
                                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2729.806704546113!2d-100.79574342327834!3d46.82780734143139!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x52d783a38df3b067%3A0x72343a8300b542c8!2s1929%20N%20Washington%20St%2C%20Bismarck%2C%20ND%2058501!5e0!3m2!1sen!2sus!4v1695244201510!5m2!1sen!2sus" width="800" height="600" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>                            </div>
                            <div class="col-md-7">
                                <h4 class="line-bottom line-bottom-theme-colored1 mt-0 mb-30 mt-sm-20">Send Us a
                                    Message</h4>
                                <!-- Contact Form -->
                                <form id="contact_form" name="contact_form" class=""
                                    action="includes/sendmail.php" method="post">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="mb-3 mb-30">
                                                <input name="form_name" class="form-control" type="text"
                                                    placeholder="Enter Name" required="">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="mb-3 mb-30">
                                                <input name="form_email" class="form-control required email"
                                                    type="email" placeholder="Enter Email">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="mb-3 mb-30">
                                                <input name="form_subject" class="form-control required"
                                                    type="text" placeholder="Enter Subject">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="mb-3 mb-30">
                                                <input name="form_phone" class="form-control" type="text"
                                                    placeholder="Enter Phone">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <textarea name="form_message" class="form-control required" rows="5" placeholder="Enter Message"></textarea>
                                    </div>
                                    <div class="mb-3">
                                        <input name="form_botcheck" class="form-control" type="hidden"
                                            value="" />
                                        <button type="submit"
                                            class="btn btn-flat btn-theme-colored1 text-uppercase mt-20 mb-sm-30 border-left-theme-colored2-4px"
                                            data-loading-text="Please wait...">Send your message</button>
                                        <button type="reset"
                                            class="btn btn-flat btn-theme-colored1 text-uppercase mt-20 mb-sm-30 border-left-theme-colored2-4px">Reset</button>
                                    </div>
                                </form>
                                <!-- Contact Form Validation-->
                                <script type="text/javascript">
                                    $("#contact_form").validate({
                                        submitHandler: function(form) {
                                            var form_btn = $(form).find('button[type="submit"]');
                                            var form_result_div = '#form-result';
                                            $(form_result_div).remove();
                                            form_btn.before(
                                                '<div id="form-result" class="alert alert-success" role="alert" style="display: none;"></div>'
                                                );
                                            var form_btn_old_msg = form_btn.html();
                                            form_btn.html(form_btn.prop('disabled', true).data("loading-text"));
                                            $(form).ajaxSubmit({
                                                dataType: 'json',
                                                success: function(data) {
                                                    if (data.status == 'true') {
                                                        $(form).find('.form-control').val('');
                                                    }
                                                    form_btn.prop('disabled', false).html(form_btn_old_msg);
                                                    $(form_result_div).html(data.message).fadeIn('slow');
                                                    setTimeout(function() {
                                                        $(form_result_div).fadeOut('slow')
                                                    }, 6000);
                                                }
                                            });
                                        }
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- end main-content -->

        <!-- Footer -->
        <footer id="footer" class="footer layer-overlay overlay-dark-9"
            data-tm-bg-img="frontend/images/bg/bg2.jpg">
            <div class="footer-widget-area">
                <div class="container pt-90 pb-60">
                    <div class="row">
                        <div class="col-md-6 col-lg-6 col-xl-3">
                            <div class="tm-widget-contact-info contact-info-style1 contact-icon-theme-colored1">
                                <div class="thumb">
                                    <img alt="Logo" src="frontend/images/logo-wide-white.png">
                                </div>
                                <div class="description">1929 N Washington St. Suite A <br/>Bismarck, ND 58501 <br/>701-415-0453 <br/>cractc.online@k12.nd.us</div>
                            </div>
                            <ul class="styled-icons icon-dark icon-theme-colored1 icon-rounded clearfix">
                                <li><a class="social-link" href="https://facebook.com/CRACTC1"><i class="fab fa-facebook"></i></a></li>
                                <li><a class="social-link" href="https://twitter.com/cractc1"><i class="fab fa-twitter"></i></a></li>
                            </ul>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3">
                            <a href="http://westernndctc.ps.state.nd.us/public">
                            <div class="tm-widget-contact-info contact-info-style1 contact-icon-theme-colored1">
                                <div class="thumb">
                                    <img alt="Logo" src="frontend/images/front/powerschool.png">
                                </div>
                                <div class="description">
                                    <h4 style="color:#ffffff">PowerSchool</h4>
                                    <p>Click here to view your individual assignment and overall grades.</p>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3">
                            <a href="https://moodle.cractc.org">
                            <div class="tm-widget-contact-info contact-info-style1 contact-icon-theme-colored1">
                                <div class="thumb">
                                    <img alt="Logo" src="frontend/images/front/moodle.png">
                                </div>
                                <div class="description">
                                    <h4 style="color:#ffffff">Moodle</h4>
                                    <p>Click here if your instructor uses Moodle to send out class materials and assignments.</p>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-md-6 col-lg-6 col-xl-3">
                            <a href="https://classroom.google.com/">
                            <div class="tm-widget-contact-info contact-info-style1 contact-icon-theme-colored1">
                                <div class="thumb">
                                    <img alt="Logo" src="frontend/images/front/classroom.png">
                                </div>
                                <div class="description">
                                    <h4 style="color:#ffffff">Google Classroom</h4>
                                    <p>Click here if your instructor uses Google Classroom to send out class materials and assignments..</p>
                                </div>
                            </div>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom" data-tm-bg-color="#2A2A2A">
                    <div class="container">
                        <div class="row pt-20 pb-20">
                            <div class="col-sm-6">
                                <div class="footer-paragraph">
                                    © CRACTC. All Rights Reserved.
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="footer-paragraph text-right">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <a class="scrollToTop" href="#"><i class="fa fa-angle-up"></i></a>
    </div>
    <!-- end wrapper -->

    <!-- Footer Scripts -->
    <!-- JS | Custom script for all pages -->
    <script src="frontend/js/custom.js"></script>

</body>

</html>
