<?php $__env->startSection('title', $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->

<!-- BEGIN BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('sections.index')); ?>">Sections</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e($title); ?></li>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>
<!-- END BREADCRUMB -->
<?php $__env->startSection('content'); ?>
    <h6>
        Course: <a href="#"><?php echo e($section->course->name); ?></a><br />
        Term: <?php echo e($section->year->year); ?> <?php echo e($section->termDesc()); ?><br />
        Teacher: <?php echo e($section->teacher->last_name . ', ' . $section->teacher->first_name); ?><br />
        Enrollments: <?php echo e($section->enrollments->count()); ?> of <?php echo e($section->enrollment_max); ?> enrolled<br />
        Delivery: <?php if($section->delivery === 'I'): ?>
            ITV
        <?php else: ?>
            Online
        <?php endif; ?>
        <br />
        Restricted Schools: 
        <?php if(!empty($section->restricted_school_ids)): ?>
            <span class="badge badge-warning">Restricted</span>
        <?php endif; ?>
        <?php echo e($section->getRestrictedSchoolNames()); ?>

        <br />
        Description: <?php echo e($section->course->description); ?>

    </h6>
    <?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 2): ?>
        <!-- List Enrollments -->
        <?php if($section->enrollments->isEmpty()): ?>
            <h4>No Enrollments Found</h4>
        <?php else: ?>
            <h4><?php echo e($section->enrollments->count()); ?> Enrollments</h4>
            <div class="table-responsive">
                <table class="table table-bordered table-hover mb-4" id="enrollments-table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>School</th>
                            <th>Status</th>
                            <th>LMS Updated?</th>
                            <th>PS Updated?</th>
                            <th>Dual Credit</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $section->enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if(isset($e->student)): ?>
                                        <?php echo e($e->student->last_name . ', ' . $e->student->first_name); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(isset($e->student)): ?>
                                        <?php echo e($e->student->school->name); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($e->status === 'A'): ?>
                                        Approved
                                    <?php elseif($e->status === 'D'): ?>
                                        Denied
                                    <?php elseif($e->status === 'R'): ?>
                                        Dropped
                                    <?php else: ?>
                                        Waitlist
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($e->lms_updated): ?>
                                        Yes
                                    <?php else: ?>
                                        No
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($e->ps_updated): ?>
                                        Yes
                                    <?php else: ?>
                                        No
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($e->dual_credit): ?>
                                        Yes
                                    <?php else: ?>
                                        No
                                    <?php endif; ?>
                                </td>
                                <td><a href="<?php echo e(route('enrollments.show', $e->id)); ?>">View</a> |
                                    <a href="<?php echo e(route('enrollments.edit', $e->id)); ?>">Edit</a> |
                                    <a href="<?php echo e(route('enrollments.delete', $e->id)); ?>">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    <?php endif; ?>
    <p class="mt-2">
        <button class="btn btn-warning mb-2"
            onclick="window.location.href = '<?php echo e(route('sections.edit', $section->id)); ?>';">Edit Section</button> <button
            class="btn btn-danger mb-2"
            onclick="window.location.href = '<?php echo e(route('sections.delete', $section->id)); ?>';">Delete Section</button>
    </p>
<?php $__env->stopSection(); ?>
<!--  BEGIN PAGE SCRIPTS FILE  -->
<?php $__env->startSection('page-js'); ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#enrollments-table').DataTable({
                "pageLength": 10,
                "lengthMenu": [25, 50, 75, 100],
                "pageLength": 50,
                "language": {
                    "emptyTable": "No enrollments found"
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<!--  END PAGE SCRIPTS FILE  -->
<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/sections/show.blade.php ENDPATH**/ ?>