<?php $__env->startSection('title', 'School Enrollment Summary Report'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Filter Form (POST for filtered data) -->
    <form method="POST" action="<?php echo e(route('reports.schoolEnrollmentSummaryFiltered')); ?>">
        <?php echo csrf_field(); ?>
        <div class="form-row input-group ms-2">
            <div class="col-md-2 mb-4">
                <label for="year">Year</label>
                <select name="year_id" id="year_id" class="form-select <?php $__errorArgs = ['year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">-- All Years --</option>
                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($year->id); ?>" <?php if(request('year_id') == $year->id || isset($yearId) && $yearId == $year->id): ?> selected <?php endif; ?>>
                            <?php echo e($year->year); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-2 mb-4 ms-2">
                <label for="provider">Provider</label>
                <select name="provider_id" id="provider_id" class="form-select <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">-- All Providers --</option>
                    <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($provider->id); ?>" <?php if(request('provider_id') == $provider->id || isset($providerId) && $providerId == $provider->id): ?> selected <?php endif; ?>>
                            <?php echo e($provider->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-2 mb-4 ms-2">
                <label for="school">School</label>
                <select name="school_id" id="school_id" class="form-select <?php $__errorArgs = ['school_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">-- All Schools --</option>
                    <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($school->id); ?>" <?php if(request('school_id') == $school->id || isset($schoolId) && $schoolId == $school->id): ?> selected <?php endif; ?>>
                            <?php echo e($school->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-1 mb-4 ms-2">
                <button type="submit" class="btn btn-primary mt-4">Apply Filters</button>
            </div>
        </div>
    </form>

    <!-- Display Report Data -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">School Enrollment Summary</h4>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $reportData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <h5><?php echo e($enrollment->school_name); ?> (<?php echo e($enrollment->year); ?>)</h5>
                        <table class="table table-bordered mb-4">
                            <thead>
                                <tr>
                                    <th>Fall</th>
                                    <th>Spring</th>
                                    <th>Full Year</th>
                                    <th><strong>Total</strong></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><?php echo e($enrollment->fall_count); ?></td>
                                    <td><?php echo e($enrollment->spring_count); ?></td>
                                    <td><?php echo e($enrollment->full_year_count); ?></td>
                                    <td><strong><?php echo e($enrollment->fall_count + $enrollment->spring_count + $enrollment->full_year_count); ?></strong></td>
                                </tr>
                            </tbody>
                        </table>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/reports/school-enrollment-summary.blade.php ENDPATH**/ ?>