<?php $__env->startSection('title', $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="/cork/src/plugins/src/table/datatable/datatables.css">
    <link rel="stylesheet" href="/cork/src/plugins/css/light/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" href="/cork/src/plugins/src/table/datatable/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Sections</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 2): ?>
        <button class="btn btn-primary m-2" onclick="window.location.href = '<?php echo e(route('sections.create')); ?>';">+ Add
            Section</button>
    <?php endif; ?>
    <form method="post" action="<?php echo e(route('sections.filterSections')); ?>">
        <?php echo csrf_field(); ?>
        <div class="form-row input-group ms-2">
            <div class="col-md-1 mb-4 ms-2">
                <label for="year_id">Year</label>
                <select name="year_id" id="year_id" class="form-select <?php $__errorArgs = ['year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($year->id); ?>" <?php if(@isset($yearid) && $year->id == $yearid): ?> selected <?php endif; ?>>
                            <?php echo e($year->year); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('year_id')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-2 mb-4 ms-2">
                <label for="department_id">Department</label>
                <select name="department_id" id="department_id"
                    class="form-select <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="0" <?php if(@isset($departmentId) && 0 == $departmentId): ?> selected <?php endif; ?>>-- All --</option>
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dept->id); ?>" <?php if(@isset($departmentId) && $dept->id == $departmentId): ?> selected <?php endif; ?>>
                            <?php echo e($dept->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('department_id')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="provider_id">Provider</label>
                <select name="provider_id" id="provider_id" class="form-select <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php if(auth()->user()->role_id == 1): ?>
                        <option value="0" <?php if(@isset($providerId) && 0 == $providerId): ?> selected <?php endif; ?>>-- All --</option>
                    <?php endif; ?>
                    <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($provider->id); ?>" <?php if(@isset($providerId) && $provider->id == $providerId): ?> selected <?php endif; ?>>
                            <?php echo e($provider->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('provider_id')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-2 mb-4 ms-2">
                <label for="teacher_id">Teacher</label>
                <select name="teacher_id" id="teacher_id" class="form-select <?php $__errorArgs = ['teacher_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="0" <?php if(@isset($teacherId) && 0 == $teacherId): ?> selected <?php endif; ?>>-- All --</option>
                    <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($t->id); ?>" <?php if(@isset($teacherId) && $t->id == $teacherId): ?> selected <?php endif; ?>>
                            <?php echo e($t->last_name); ?>, <?php echo e($t->first_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['teacher_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('teacher_id')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="term">Term</label>
                <select name="term" id="term" class="form-select <?php $__errorArgs = ['term'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="A" <?php if(@isset($term) && 'A' == $term): ?> selected <?php endif; ?>>-- All --</option>
                    <option value="Y" <?php if(@isset($term) && 'Y' == $term): ?> selected <?php endif; ?>>Full Year</option>
                    <option value="F" <?php if(@isset($term) && 'F' == $term): ?> selected <?php endif; ?>>Fall</option>
                    <option value="S" <?php if(@isset($term) && 'S' == $term): ?> selected <?php endif; ?>>Spring</option>
                </select>
                <?php $__errorArgs = ['term'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('term')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="dual_credit">Dual Credit</label>
                <select name="dual_credit" id="dual_credit" class="form-select <?php $__errorArgs = ['dual_credit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="A" <?php if(@isset($dualCredit) && 'A' == $dualCredit): ?> selected <?php endif; ?>>-- All --</option>
                    <option value="0" <?php if(@isset($dualCredit) && 0 == $dualCredit): ?> selected <?php endif; ?>>No</option>
                    <option value="1" <?php if(@isset($dualCredit) && 1 == $dualCredit): ?> selected <?php endif; ?>>Yes</option>
                </select>
                <?php $__errorArgs = ['dual_credit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('dual_credit')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="availability">Availability</label>
                <select name="availability" id="availability"
                    class="form-select <?php $__errorArgs = ['availability'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="A" <?php if(@isset($availability) && 'A' == $availability): ?> selected <?php endif; ?>>-- All --</option>
                    <option value="O" <?php if(@isset($availability) && 'O' == $availability): ?> selected <?php endif; ?>>Open</option>
                    <option value="W" <?php if(@isset($availability) && 'W' == $availability): ?> selected <?php endif; ?>>Waitlist</option>
                </select>
                <?php $__errorArgs = ['availability'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('availability')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2 mt-2">
                <button type="submit" class="mt-4 btn btn-primary">Apply</button>
            </div>
        </div>
    </form>
    <table id="sections" class="table dt-table-hover" style="width:100%">
        <thead>
            <tr>
                <th>Year</th>
                <th>Course</th>
                <th>Provider</th>
                <th>Enrollments</th>
                <th>Dept</th>
                <th>Term</th>
                <th>Teacher</th>
                <th class="no-content">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $s = App\Models\Section::find($s->id) ?>
                <tr>
                    <td><?php echo e($s->year->year); ?></td>
                    <td>
                        <?php if(isset($s->course)): ?>
                            <?php echo e($s->course->name); ?>

                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if(isset($s->provider->name)): ?>
                            <?php echo e($s->provider->name); ?>

                        <?php endif; ?>
                    </td>
                    <td
                        <?php if($s->enrollments->count() >= $s->enrollment_max): ?> style="color:red" <?php elseif($s->enrollments->count() >= 0.75 * $s->enrollment_max): ?> style="color:#eed202" <?php else: ?> style="color:#00AB66" <?php endif; ?>>
                        <?php if($s->enrollments->count() >= $s->enrollment_max && auth()->user()->role_id == 3): ?>
                            Waitlist
                        <?php else: ?>
                            <?php echo e($s->enrollments->count()); ?> of <?php echo e($s->enrollment_max); ?>

                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if(isset($s->course->department->name)): ?>
                            <?php echo e($s->course->department->name); ?>

                        <?php endif; ?>
                    </td>
                    <td><?php echo e($s->termDesc()); ?></td>
                    <td><?php echo e($s->teacher->last_name . ', ' . substr($s->teacher->first_name, 0, 1)); ?></td>
                    <td>
                        <a href="<?php echo e(route('sections.show', $s->id)); ?>"><svg xmlns="http://www.w3.org/2000/svg"
                                height="1em" viewBox="0 0 576 512">
                                <path
                                    d="M288 32c-80.8 0-145.5 36.8-192.6 80.6C48.6 156 17.3 208 2.5 243.7c-3.3 7.9-3.3 16.7 0 24.6C17.3 304 48.6 356 95.4 399.4C142.5 443.2 207.2 480 288 480s145.5-36.8 192.6-80.6c46.8-43.5 78.1-95.4 93-131.1c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C433.5 68.8 368.8 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35.3-28.7 64-64 64c-7.1 0-13.9-1.2-20.3-3.3c-5.5-1.8-11.9 1.6-11.7 7.4c.3 6.9 1.3 13.8 3.2 20.7c13.7 51.2 66.4 81.6 117.6 67.9s81.6-66.4 67.9-117.6c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7c2.1 6.4 3.3 13.2 3.3 20.3z" />
                            </svg></a>&nbsp;
                        <?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 2): ?>
                            <a href="<?php echo e(route('sections.edit', $s->id)); ?>"><svg xmlns="http://www.w3.org/2000/svg"
                                    height="1em" viewBox="0 0 512 512">
                                    <path
                                        d="M362.7 19.3L314.3 67.7 444.3 197.7l48.4-48.4c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0zm-71 71L58.6 323.5c-10.4 10.4-18 23.3-22.2 37.4L1 481.2C-1.5 489.7 .8 498.8 7 505s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L421.7 220.3 291.7 90.3z" />
                                </svg></a>&nbsp;
                            <?php if($s->enrollmentsAnyStatus->count() == 0): ?>
                            <a href="<?php echo e(route('sections.delete', $s->id)); ?>"><svg xmlns="http://www.w3.org/2000/svg"
                                    height="1em" viewBox="0 0 448 512">
                                    <path
                                        d="M135.2 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8c-12.1 0-23.2 6.8-28.6 17.7zM416 128H32L53.2 467c1.6 25.3 22.6 45 47.9 45H346.9c25.3 0 46.3-19.7 47.9-45L416 128z" />
                                </svg></a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php $__env->stopSection(); ?>
<!--  BEGIN PAGE SCRIPTS FILE  -->
<?php $__env->startSection('page-js'); ?>
    <script src="/cork/src/plugins/src/table/datatable/datatables.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function() {
            var table = $('#sections').DataTable({
                "dom": "<'dt--top-section'<'row'<'col-12 col-sm-6 d-flex justify-content-sm-start justify-content-center'l><'col-12 col-sm-6 d-flex justify-content-sm-end justify-content-center mt-sm-0 mt-3'f>>>" +
                    "<'table-responsive'tr>" +
                    "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
                "oLanguage": {
                    "oPaginate": {
                        "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>',
                        "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>'
                    },
                    "sInfo": "Showing page _PAGE_ of _PAGES_",
                    "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                    "sSearchPlaceholder": "Search...",
                    "sLengthMenu": "Results :  _MENU_",
                },
                "stripeClasses": [],
                "lengthMenu": [25, 50, 75, 100],
                "pageLength": 100,
                "order": [
                    [1, "asc"]
                ]
            });

            // Manually create and add the Excel export button
            var excelButton = $('<button class="btn btn-primary ms-2">Export to Excel</button>');
            $('.dt--top-section .col-sm-6:first-child').append(excelButton);

            excelButton.on('click', function() {
                // Prepare the data
                var data = [
                    // Headers
                    table.columns(':visible').header().toArray().slice(0, 7).map(function(header) {
                        return header.textContent.trim();
                    })
                ];

                // Add row data
                table.rows({
                    search: 'applied'
                }).every(function(rowIdx) {
                    var rowData = this.data();
                    data.push(rowData.slice(0, 7).map(function(cell) {
                        return cell.toString().trim();
                    }));
                });

                // Create a worksheet
                var ws = XLSX.utils.aoa_to_sheet(data);

                // Create a workbook
                var wb = XLSX.utils.book_new();
                XLSX.utils.book_append_sheet(wb, ws, "Sections");

                // Generate Excel file
                XLSX.writeFile(wb, "Sections_Export_" + new Date().toISOString().slice(0, 10) + ".xlsx");
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<!--  END PAGE SCRIPTS FILE  -->

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/sections/index.blade.php ENDPATH**/ ?>