<?php $__env->startSection('title', $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/src/table/datatable/datatables.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/custom_dt_miscellaneous.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/custom_dt_miscellaneous.css">
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Enrollments</li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <form method="post" action="<?php echo e(route('reports.enrollmentsByDepartmentFiltered')); ?>">
        <?php echo csrf_field(); ?>
        <div class="form-row input-group ms-2">
            <div class="col-md-1 mb-4">
                <label for="ps_updated">Year</label>
                <select name="year_id" id="year_id" class="form-select <?php $__errorArgs = ['year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($year->id); ?>" <?php if(@isset($yearId) && $year->id == $yearId): ?> selected <?php endif; ?>>
                            <?php echo e($year->year); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['year_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('year_id')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-2 mb-4 ms-2">
                <label for="department_id">Department</label>
                <select name="department_id" id="department_id"
                    class="form-select <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="0" <?php if(@isset($departmentId) && 0 == $departmentId): ?> selected <?php endif; ?>>-- All --</option>
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($d->id); ?>" <?php if(@isset($departmentId) && $d->id == $departmentId): ?> selected <?php endif; ?>>
                            <?php echo e($d->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('department_id')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="provider_id">Provider</label>
                <select name="provider_id" id="provider_id" class="form-select <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="0" <?php if(@isset($providerId) && 0 == $providerId): ?> selected <?php endif; ?>>-- All --</option>
                    <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($provider->id); ?>" <?php if(@isset($providerId) && $provider->id == $providerId): ?> selected <?php endif; ?>>
                            <?php echo e($provider->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('provider_id')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="ps_updated">Status</label>
                <select name="status" id="status" class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="ALL" <?php if(@isset($status) && 'ALL' == $status): ?> selected <?php endif; ?>>-- All --</option>
                    <option value="A" <?php if(@isset($status) && 'A' == $status): ?> selected <?php endif; ?>>Approved</option>
                    <option value="D" <?php if(@isset($status) && 'D' == $status): ?> selected <?php endif; ?>>Denied</option>
                    <option value="R" <?php if(@isset($status) && 'R' == $status): ?> selected <?php endif; ?>>Dropped</option>
                    <option value="W" <?php if(@isset($status) && 'W' == $status): ?> selected <?php endif; ?>>Waitlist</option>
                </select>
                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('status')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="term">Term</label>
                <select name="term" id="term" class="form-select <?php $__errorArgs = ['term'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="A" <?php if(@isset($term) && 'A' == $term): ?> selected <?php endif; ?>>-- All --</option>
                    <option value="Y" <?php if(@isset($term) && 'Y' == $term): ?> selected <?php endif; ?>>Full Year</option>
                    <option value="F" <?php if(@isset($term) && 'F' == $term): ?> selected <?php endif; ?>>Fall</option>
                    <option value="S" <?php if(@isset($term) && 'S' == $term): ?> selected <?php endif; ?>>Spring</option>
                </select>
                <?php $__errorArgs = ['term'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('term')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-1 mb-4 ms-2">
                <label for="grade">Grade</label>
                <select name="grade" id="grade" class="form-select <?php $__errorArgs = ['grade'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="0" <?php if(@isset($grade) && 0 == $grade): ?> selected <?php endif; ?>>-- All --</option>
                    <option value="12" <?php if(@isset($grade) && 12 == $grade): ?> selected <?php endif; ?>>12</option>
                    <option value="11" <?php if(@isset($grade) && 11 == $grade): ?> selected <?php endif; ?>>11</option>
                    <option value="10" <?php if(@isset($grade) && 10 == $grade): ?> selected <?php endif; ?>>10</option>
                    <option value="9" <?php if(@isset($grade) && 9 == $grade): ?> selected <?php endif; ?>>9</option>
                </select>
                <?php $__errorArgs = ['grade'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback" style="display: block !important;">
                        <?php echo e($errors->first('grade')); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-md-2 mb-4 ms-2 mt-2">
                <button type="submit" class="mt-4 btn btn-primary">Apply</button>
            </div>
        </div>
    </form>

    <div class="widget-content widget-content-area table-responsive">
        <table id="enrollments" class="table dt-table-hover" style="width:100%">
            <thead>
                <tr>
                    <th>Department</th>
                    <?php $__currentLoopData = $providersFiltered; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e($p->name); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php
                ?>
                <?php $__currentLoopData = $departmentsFiltered; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($d->name); ?></td>
                        <?php $__currentLoopData = $providersFiltered; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td><?php echo e(App\Models\Enrollment::enrollmentSQLBuilder($yearId, 0, $p->id, $d->id, 0, $status, $term, $grade)->count()); ?>

                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e(App\Models\Enrollment::enrollmentSQLBuilder($yearId, 0, $providerId, $d->id, 0, $status, $term, $grade)->count()); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr>
                    <th>&nbsp;</th>
                    <?php $__currentLoopData = $providersFiltered; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $departmentTotal = 0; ?>
                        <th style="align:center">
                            <?php echo e(App\Models\Enrollment::enrollmentSQLBuilder($yearId, 0, $p->id, $departmentId, 0, $status, $term, $grade)->count()); ?>

                        </th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e(App\Models\Enrollment::enrollmentSQLBuilder($yearId, 0, $providerId, $departmentId, 0, $status, $term, $grade)->count()); ?>

                    </th>
                </tr>
                <tr>
                    <th>Department</th>
                    <?php $__currentLoopData = $providersFiltered; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e($p->name); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th>Total</th>
                </tr>
            </tfoot>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<!--  BEGIN PAGE SCRIPTS FILE  -->
<?php $__env->startSection('page-js'); ?>
    <script src="/cork/src/plugins/src/table/datatable/datatables.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/dataTables.buttons.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/jszip.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/buttons.html5.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/buttons.print.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#enrollments').DataTable({
                "dom": "<'dt--top-section'<'row'<'col-sm-12 col-md-6 d-flex justify-content-md-start justify-content-center'B><'col-sm-12 col-md-6 d-flex justify-content-md-end justify-content-center mt-md-0 mt-3'f>>>" +
                    "<'table-responsive'tr>" +
                    "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
                buttons: {
                    buttons: [{
                            extend: 'csv',
                            className: 'btn',
                            footer: true
                        },
                        {
                            extend: 'excel',
                            className: 'btn',
                            footer: true
                        },
                        {
                            extend: 'print',
                            className: 'btn',
                            footer: true
                        }
                    ]
                },
                "oLanguage": {
                    "oPaginate": {
                        "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>',
                        "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>'
                    },
                    "sInfo": "Showing page _PAGE_ of _PAGES_",
                    "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                    "sSearchPlaceholder": "Search...",
                    "sLengthMenu": "Results :  _MENU_",
                },
                "stripeClasses": [],
                "lengthMenu": [7, 10, 20, 50],
                "pageLength": -1
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<!--  END PAGE SCRIPTS FILE  -->

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/reports/enrollments-by-department.blade.php ENDPATH**/ ?>