<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
$controller_path = 'App\Http\Controllers';

//Route::get('/', $controller_path . '\FrontEndController@index')->name('index');
Route::get('/', function () {
    return view('frontend.index');
});

Route::get('/layout', function () {
    return view('layouts.cork');
});

Route::get('/admin/dashboard', $controller_path . '\DashboardController@index')->name('dashboard')->middleware('auth');
Route::get('/dashboard', $controller_path . '\DashboardController@index')->name('dashboard')->middleware('auth');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';

//Users
Route::get('/admin/users', $controller_path . '\UserController@index')->name('users.index')->middleware('auth');
Route::post('/admin/users/store', $controller_path . '\UserController@store')->name('users.store')->middleware('auth');
Route::get('/admin/users/create', $controller_path . '\UserController@create')->name('users.create')->middleware('auth');
Route::get('/admin/users/{user}', $controller_path . '\UserController@show')->name('users.show')->middleware('auth');
Route::get('/admin/users/{user}/edit', $controller_path . '\UserController@edit')->name('users.edit')->middleware('auth');
Route::put('/admin/users/{user}/update', $controller_path . '\UserController@update')->name('users.update')->middleware('auth');
Route::get('/admin/users/{user}/delete', $controller_path . '\UserController@delete')->name('users.delete')->middleware('auth');
Route::delete('/admin/users/{user}/destroy', $controller_path . '\UserController@destroy')->name('users.destroy')->middleware('auth');
Route::get('/admin/bulkupload/users', $controller_path . '\UserController@bulkUpload')->name('users.bulkupload')->middleware('auth');

//Students
Route::get('/admin/students', $controller_path . '\StudentController@index')->name('students.index')->middleware('auth');
Route::post('/admin/students/store', $controller_path . '\StudentController@store')->name('students.store')->middleware('auth');
Route::get('/admin/students/create', $controller_path . '\StudentController@create')->name('students.create')->middleware('auth');
Route::get('/admin/students/needs_ssid', $controller_path . '\StudentController@needsSSID')->name('students.needs_ssid')->middleware('auth');
Route::get('/admin/students/{student}', $controller_path . '\StudentController@show')->name('students.show')->middleware('auth');
Route::get('/admin/students/{student}/edit', $controller_path . '\StudentController@edit')->name('students.edit')->middleware('auth');
Route::put('/admin/students/{student}/update', $controller_path . '\StudentController@update')->name('students.update')->middleware('auth');
Route::get('/admin/students/{student}/delete', $controller_path . '\StudentController@delete')->name('students.delete')->middleware('auth');
Route::delete('/admin/students/{student}/destroy', $controller_path . '\StudentController@destroy')->name('students.destroy')->middleware('auth');
Route::get('/admin/bulkupload/students', $controller_path . '\StudentController@bulkUpload')->name('students.bulkupload')->middleware('auth');

//Teachers
Route::get('/admin/teachers', $controller_path . '\TeacherController@index')->name('teachers.index')->middleware('auth');
Route::post('/admin/teachers/store', $controller_path . '\TeacherController@store')->name('teachers.store')->middleware('auth');
Route::get('/admin/teachers/create', $controller_path . '\TeacherController@create')->name('teachers.create')->middleware('auth');
Route::get('/admin/teachers/{teacher}', $controller_path . '\TeacherController@show')->name('teachers.show')->middleware('auth');
Route::get('/admin/teachers/{teacher}/edit', $controller_path . '\TeacherController@edit')->name('teachers.edit')->middleware('auth');
Route::put('/admin/teachers/{teacher}/update', $controller_path . '\TeacherController@update')->name('teachers.update')->middleware('auth');
Route::get('/admin/teachers/{teacher}/delete', $controller_path . '\TeacherController@delete')->name('teachers.delete')->middleware('auth');
Route::delete('/admin/teachers/{teacher}/destroy', $controller_path . '\TeacherController@destroy')->name('teachers.destroy')->middleware('auth');

//Schools
Route::get('/admin/schools', $controller_path . '\SchoolController@index')->name('schools.index')->middleware('auth');
Route::post('/admin/schools/store', $controller_path . '\SchoolController@store')->name('schools.store')->middleware('auth');
Route::get('/admin/schools/create', $controller_path . '\SchoolController@create')->name('schools.create')->middleware('auth');
Route::get('/admin/schools/{school}', $controller_path . '\SchoolController@show')->name('schools.show')->middleware('auth');
Route::get('/admin/schools/{school}/edit', $controller_path . '\SchoolController@edit')->name('schools.edit')->middleware('auth');
Route::put('/admin/schools/{school}/update', $controller_path . '\SchoolController@update')->name('schools.update')->middleware('auth');
Route::get('/admin/schools/{school}/delete', $controller_path . '\SchoolController@delete')->name('schools.delete')->middleware('auth');
Route::delete('/admin/schools/{school}/destroy', $controller_path . '\SchoolController@destroy')->name('schools.destroy')->middleware('auth');

//Enrollments
Route::get('/admin/enrollments', $controller_path . '\EnrollmentController@index')->name('enrollments.index')->middleware('auth');
Route::post('/admin/enrollments', $controller_path . '\EnrollmentController@filterEnrollments')->name('enrollments.filterEnrollments')->middleware('auth');
Route::get('/admin/enrollments/bps-medterm-upload', $controller_path . '\EnrollmentController@BPSMedTermStudentUploadForm')->name('enrollments.bps-medterm-upload-form')->middleware('auth');
Route::post('/admin/enrollments/bps-medterm-upload', $controller_path . '\EnrollmentController@BPSMedTermStudentUpload')->name('enrollments.bps-medterm-upload')->middleware('auth');
Route::post('/admin/enrollments/bps-medterm-upload-preview', $controller_path . '\EnrollmentController@BPSMedTermStudentUploadPreview')->name('enrollments.bps-medterm-upload-preview')->middleware('auth');
Route::get('/admin/enrollments/waitlist', $controller_path . '\EnrollmentController@waitList')->name('enrollments.waitList')->middleware('auth');
Route::post('/admin/enrollments/waitlist', $controller_path . '\EnrollmentController@filterWaitListEnrollments')->name('enrollments.filterWaitListEnrollments')->middleware('auth');
Route::post('/admin/enrollments/store', $controller_path . '\EnrollmentController@store')->name('enrollments.store')->middleware('auth');
Route::get('/admin/enrollments/create', $controller_path . '\EnrollmentController@create')->name('enrollments.create')->middleware('auth');
Route::get('/admin/enrollments/create/year/{yearid}/term/{term}', $controller_path . '\EnrollmentController@create2')->name('enrollments.create2')->middleware('auth');
Route::get('/admin/enrollments/{enrollment}', $controller_path . '\EnrollmentController@show')->name('enrollments.show')->middleware('auth');
Route::get('/admin/enrollments/{enrollment}/edit', $controller_path . '\EnrollmentController@edit')->name('enrollments.edit')->middleware('auth');
Route::put('/admin/enrollments/{enrollment}/update', $controller_path . '\EnrollmentController@update')->name('enrollments.update')->middleware('auth');
Route::get('/admin/enrollments/{enrollment}/delete', $controller_path . '\EnrollmentController@delete')->name('enrollments.delete')->middleware('auth');
Route::delete('/admin/enrollments/{enrollment}/destroy', $controller_path . '\EnrollmentController@destroy')->name('enrollments.destroy')->middleware('auth');
Route::get('/admin/enrollments/{enrollment}/drop', $controller_path . '\EnrollmentController@drop')->name('enrollments.drop')->middleware('auth');
Route::put('/admin/enrollments/{enrollment}/dropconfirm', $controller_path . '\EnrollmentController@dropConfirm')->name('enrollments.dropconfirm')->middleware('auth');
Route::get('/admin/enrollments/show-hide-dual-credit/section/{sectionId}', $controller_path . '\EnrollmentController@showHideDualCredit')->name('enrollments.showHideDualCredit')->middleware('auth');
Route::get('/admin/enrollments/misc/upload-moodle-students', $controller_path . '\EnrollmentController@uploadMoodleStudents')->name('enrollments.upload-moodle-students')->middleware('auth');
Route::post('/admin/enrollments/misc/upload-moodle-students', $controller_path . '\EnrollmentController@updateLmsForEnrollments')->middleware('auth');
Route::get('/admin/enrollments/misc/upload-powerschool-students', $controller_path . '\EnrollmentController@uploadPowerSchoolStudents')->name('enrollments.upload-powerschool-students')->middleware('auth');
Route::post('/admin/enrollments/misc/upload-powerschool-students', $controller_path . '\EnrollmentController@updatePowerSchoolForEnrollments')->middleware('auth');

//Courses
Route::get('/admin/courses', $controller_path . '\CourseController@index')->name('courses.index')->middleware('auth');
Route::post('/admin/courses/store', $controller_path . '\CourseController@store')->name('courses.store')->middleware('auth');
Route::get('/admin/courses/create', $controller_path . '\CourseController@create')->name('courses.create')->middleware('auth');
Route::get('/admin/courses/{course}', $controller_path . '\CourseController@show')->name('courses.show')->middleware('auth');
Route::get('/admin/courses/{course}/edit', $controller_path . '\CourseController@edit')->name('courses.edit')->middleware('auth');
Route::put('/admin/courses/{course}/update', $controller_path . '\CourseController@update')->name('courses.update')->middleware('auth');
Route::get('/admin/courses/{course}/delete', $controller_path . '\CourseController@delete')->name('courses.delete')->middleware('auth');
Route::delete('/admin/courses/{course}/destroy', $controller_path . '\CourseController@destroy')->name('courses.destroy')->middleware('auth');

//Sections
Route::get('/admin/sections', $controller_path . '\SectionController@index')->name('sections.index')->middleware('auth');
Route::post('/admin/sections', $controller_path . '\SectionController@filterSections')->name('sections.filterSections')->middleware('auth');
Route::post('/admin/sections/store', $controller_path . '\SectionController@store')->name('sections.store')->middleware('auth');
Route::get('/admin/sections/create', $controller_path . '\SectionController@create')->name('sections.create')->middleware('auth');
Route::get('/admin/sections/{section}', $controller_path . '\SectionController@show')->name('sections.show')->middleware('auth');
Route::get('/admin/sections/{section}/edit', $controller_path . '\SectionController@edit')->name('sections.edit')->middleware('auth');
Route::put('/admin/sections/{section}/update', $controller_path . '\SectionController@update')->name('sections.update')->middleware('auth');
Route::get('/admin/sections/{section}/delete', $controller_path . '\SectionController@delete')->name('sections.delete')->middleware('auth');
Route::delete('/admin/sections/{section}/destroy', $controller_path . '\SectionController@destroy')->name('sections.destroy')->middleware('auth');
Route::get('/admin/sections/sections-by-term/year/{yearid}/provider/{providerid}/term/{term}', $controller_path . '\SectionController@showSectionsForEnrollment')->name('sections.showSectionsByTerm')->middleware('auth');

//Contacts
Route::get('/admin/contacts', $controller_path . '\ContactController@index')->name('contacts.index')->middleware('auth');
Route::post('/admin/contacts/store', $controller_path . '\ContactController@store')->name('contacts.store')->middleware('auth');
Route::get('/admin/contacts/create', $controller_path . '\ContactController@create')->name('contacts.create')->middleware('auth');
Route::get('/admin/contacts/{contact}', $controller_path . '\ContactController@show')->name('contacts.show')->middleware('auth');
Route::get('/admin/contacts/{contact}/edit', $controller_path . '\ContactController@edit')->name('contacts.edit')->middleware('auth');
Route::put('/admin/contacts/{contact}/update', $controller_path . '\ContactController@update')->name('contacts.update')->middleware('auth');
Route::get('/admin/contacts/{contact}/delete', $controller_path . '\ContactController@delete')->name('contacts.delete')->middleware('auth');
Route::delete('/admin/contacts/{contact}/destroy', $controller_path . '\ContactController@destroy')->name('contacts.destroy')->middleware('auth');

//Departments
Route::get('/admin/departments', $controller_path . '\DepartmentController@index')->name('departments.index')->middleware('auth');
Route::post('/admin/departments/store', $controller_path . '\DepartmentController@store')->name('departments.store')->middleware('auth');
Route::get('/admin/departments/create', $controller_path . '\DepartmentController@create')->name('departments.create')->middleware('auth');
Route::get('/admin/departments/{department}', $controller_path . '\DepartmentController@show')->name('departments.show')->middleware('auth');
Route::get('/admin/departments/{department}/edit', $controller_path . '\DepartmentController@edit')->name('departments.edit')->middleware('auth');
Route::put('/admin/departments/{department}/update', $controller_path . '\DepartmentController@update')->name('departments.update')->middleware('auth');
Route::get('/admin/departments/{department}/delete', $controller_path . '\DepartmentController@delete')->name('departments.delete')->middleware('auth');
Route::delete('/admin/departments/{department}/destroy', $controller_path . '\DepartmentController@destroy')->name('departments.destroy')->middleware('auth');

//Equipment
Route::get('/admin/equipment', $controller_path . '\EquipmentController@index')->name('equipment.index')->middleware('auth');
Route::post('/admin/equipment/store', $controller_path . '\EquipmentController@store')->name('equipment.store')->middleware('auth');
Route::get('/admin/equipment/create', $controller_path . '\EquipmentController@create')->name('equipment.create')->middleware('auth');
Route::get('/admin/equipment/{equipment}', $controller_path . '\EquipmentController@show')->name('equipment.show')->middleware('auth');
Route::get('/admin/equipment/{equipment}/edit', $controller_path . '\EquipmentController@edit')->name('equipment.edit')->middleware('auth');
Route::put('/admin/equipment/{equipment}/update', $controller_path . '\EquipmentController@update')->name('equipment.update')->middleware('auth');
Route::get('/admin/equipment/{equipment}/delete', $controller_path . '\EquipmentController@delete')->name('equipment.delete')->middleware('auth');
Route::delete('/admin/equipment/{equipment}/destroy', $controller_path . '\EquipmentController@destroy')->name('equipment.destroy')->middleware('auth');

//Equipment Loans
Route::get('/admin/equipment-loans', $controller_path . '\EquipmentLoanController@index')->name('equipment-loans.index')->middleware('auth');
Route::post('/admin/equipment-loans/store', $controller_path . '\EquipmentLoanController@store')->name('equipment-loans.store')->middleware('auth');
Route::get('/admin/equipment-loans/create', $controller_path . '\EquipmentLoanController@create')->name('equipment-loans.create')->middleware('auth');
Route::get('/admin/equipment-loans/{equipment}', $controller_path . '\EquipmentLoanController@show')->name('equipment-loans.show')->middleware('auth');
Route::get('/admin/equipment-loans/{equipment}/edit', $controller_path . '\EquipmentLoanController@edit')->name('equipment-loans.edit')->middleware('auth');
Route::put('/admin/equipment-loans/{equipment}/update', $controller_path . '\EquipmentLoanController@update')->name('equipment-loans.update')->middleware('auth');
Route::get('/admin/equipment-loans/{equipment}/delete', $controller_path . '\EquipmentLoanController@delete')->name('equipment-loans.delete')->middleware('auth');
Route::delete('/admin/equipment-loans/{equipment}/destroy', $controller_path . '\EquipmentLoanController@destroy')->name('equipment-loans.destroy')->middleware('auth');

// Custom route for check-in process
Route::get('/admin/equipment-loans/{loan}/check-in', $controller_path . '\EquipmentLoanController@checkIn')->name('equipment-loans.check-in')->middleware('auth');

Route::post('equipment-loans/{loan}/process-check-in', [EquipmentLoanController::class, 'processCheckIn'])->name('equipment-loans.process-check-in');

//Positions
Route::get('/admin/positions', $controller_path . '\PositionController@index')->name('positions.index')->middleware('auth');
Route::post('/admin/positions/store', $controller_path . '\PositionController@store')->name('positions.store')->middleware('auth');
Route::get('/admin/positions/create', $controller_path . '\PositionController@create')->name('positions.create')->middleware('auth');
Route::get('/admin/positions/{position}', $controller_path . '\PositionController@show')->name('positions.show')->middleware('auth');
Route::get('/admin/positions/{position}/edit', $controller_path . '\PositionController@edit')->name('positions.edit')->middleware('auth');
Route::put('/admin/positions/{position}/update', $controller_path . '\PositionController@update')->name('positions.update')->middleware('auth');
Route::get('/admin/positions/{position}/delete', $controller_path . '\PositionController@delete')->name('positions.delete')->middleware('auth');
Route::delete('/admin/positions/{position}/destroy', $controller_path . '\PositionController@destroy')->name('positions.destroy')->middleware('auth');

//Years
Route::get('/admin/years', $controller_path . '\YearController@index')->name('years.index')->middleware('auth');
Route::post('/admin/years/store', $controller_path . '\YearController@store')->name('years.store')->middleware('auth');
Route::get('/admin/years/create', $controller_path . '\YearController@create')->name('years.create')->middleware('auth');
Route::get('/admin/years/{year}', $controller_path . '\YearController@show')->name('years.show')->middleware('auth');
Route::get('/admin/years/{year}/edit', $controller_path . '\YearController@edit')->name('years.edit')->middleware('auth');
Route::put('/admin/years/{year}/update', $controller_path . '\YearController@update')->name('years.update')->middleware('auth');
Route::get('/admin/years/{year}/delete', $controller_path . '\YearController@delete')->name('years.delete')->middleware('auth');
Route::delete('/admin/years/{year}/destroy', $controller_path . '\YearController@destroy')->name('years.destroy')->middleware('auth');

//Reports
Route::get('/admin/reports', $controller_path . '\ReportController@index')->name('reports.index')->middleware('auth');
Route::get('/admin/reports/enrollments-by-section-by-school', $controller_path . '\ReportController@enrollmentsBySectionBySchool')->name('reports.enrollmentsBySectionBySchool')->middleware('auth');
Route::post('/admin/reports/enrollments-by-section-by-school', $controller_path . '\ReportController@enrollmentsBySectionBySchoolFiltered')->name('reports.enrollmentsBySectionBySchoolFiltered')->middleware('auth');
Route::get('/admin/reports/enrollments-by-department', $controller_path . '\ReportController@enrollmentsByDepartment')->name('reports.enrollmentsByDepartment')->middleware('auth');
Route::post('/admin/reports/enrollments-by-department', $controller_path . '\ReportController@enrollmentsByDepartmentFiltered')->name('reports.enrollmentsByDepartmentFiltered')->middleware('auth');
Route::get('/admin/reports/school-enrollment-report', $controller_path . '\ReportController@schoolEnrollmentReport')->name('reports.schoolEnrollmentReport')->middleware('auth');
Route::post('/admin/reports/send-school-enrollment-reports', $controller_path . '\ReportController@sendSchoolEnrollmentReports')->name('reports.sendSchoolEnrollmentReports')->middleware('auth');
Route::post('/admin/reports/school-enrollment-report', $controller_path . '\ReportController@schoolEnrollmentReportFiltered')->name('reports.schoolEnrollmentReportFiltered')->middleware('auth');
Route::post('/admin/reports/school-enrollment-report', $controller_path . '\ReportController@schoolEnrollmentReportFiltered')->name('reports.schoolEnrollmentReportFiltered')->middleware('auth');
Route::post('/admin/reports/send-school-enrollment-reports', $controller_path . '\ReportController@sendSchoolEnrollmentReports')->name('reports.sendSchoolEnrollmentReports')->middleware('auth');
Route::get('/admin/reports/school-enrollment-summary', $controller_path . '\ReportController@showSchoolEnrollmentSummary')->name('reports.schoolEnrollmentSummary')->middleware('auth');
Route::post('/admin/reports/school-enrollment-summary', $controller_path . '\ReportController@showSchoolEnrollmentSummaryFiltered')->name('reports.schoolEnrollmentSummaryFiltered')->middleware('auth');

//Welcome Letters
Route::get('/admin/welcome-letters', $controller_path . '\WelcomeLetterController@index')->name('welcome-letters.index')->middleware('auth');
Route::post('/admin/welcome-letters/store', $controller_path . '\WelcomeLetterController@store')->name('welcome-letters.store')->middleware('auth');
Route::get('/admin/welcome-letters/create', $controller_path . '\WelcomeLetterController@create')->name('welcome-letters.create')->middleware('auth');
Route::get('/admin/welcome-letters/{welcomeLetter}', $controller_path . '\WelcomeLetterController@show')->name('welcome-letters.show')->middleware('auth');
Route::get('/admin/welcome-letters/{welcomeLetter}/edit', $controller_path . '\WelcomeLetterController@edit')->name('welcome-letters.edit')->middleware('auth');
Route::put('/admin/welcome-letters/{welcomeLetter}/update', $controller_path . '\WelcomeLetterController@update')->name('welcome-letters.update')->middleware('auth');
Route::get('/admin/welcome-letters/{welcomeLetter}/delete', $controller_path . '\WelcomeLetterController@delete')->name('welcome-letters.delete')->middleware('auth');
Route::delete('/admin/welcome-letters/{welcomeLetter}/destroy', $controller_path . '\WelcomeLetterController@destroy')->name('welcome-letters.destroy')->middleware('auth');
Route::get('/admin/welcome-letters/{welcomeLetter}/bulk-send', $controller_path . '\WelcomeLetterController@bulkSend')->name('welcome-letters.bulk-send')->middleware('auth');
Route::post('/admin/welcome-letters/{welcomeLetter}/bulk-send', $controller_path . '\WelcomeLetterController@bulkSendConfirm')->name('welcome-letters.bulk-send-confirm')->middleware('auth');

Route::prefix('equipment-checkout')->group(function () {
    Route::get('/', [EquipmentCheckoutController::class, 'index'])->name('equipment-checkout.index');
    Route::get('/create', [EquipmentCheckoutController::class, 'create'])->name('equipment-checkout.create');
    Route::post('/', [EquipmentCheckoutController::class, 'store'])->name('equipment-checkout.store');
    Route::get('/{id}', [EquipmentCheckoutController::class, 'show'])->name('equipment-checkout.show');
    Route::get('/{id}/edit', [EquipmentCheckoutController::class, 'edit'])->name('equipment-checkout.edit');
    Route::put('/{id}', [EquipmentCheckoutController::class, 'update'])->name('equipment-checkout.update');
    Route::delete('/{id}', [EquipmentCheckoutController::class, 'destroy'])->name('equipment-checkout.delete');
});
